/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <important>
 * <p>
 * <i> <b>Cost Category is in public beta for AWS Billing and Cost Management and is subject to change. Your use of Cost
 * Categories is subject to the Beta Service Participation terms of the <a
 * href="https://aws.amazon.com/service-terms/">AWS Service Terms</a> (Section 1.10).</b> </i>
 * </p>
 * </important>
 * <p>
 * The structure of Cost Categories. This includes detailed metadata and the set of rules for the
 * <code>CostCategory</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostCategory implements SdkPojo, Serializable, ToCopyableBuilder<CostCategory.Builder, CostCategory> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategory::costCategoryArn)).setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategory::effectiveStart)).setter(setter(Builder::effectiveStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()).build();

    private static final SdkField<String> EFFECTIVE_END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategory::effectiveEnd)).setter(setter(Builder::effectiveEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEnd").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategory::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CostCategory::ruleVersionAsString)).setter(setter(Builder::ruleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()).build();

    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField
            .<List<CostCategoryRule>> builder(MarshallingType.LIST)
            .getter(getter(CostCategory::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategoryRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategoryRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD,
            EFFECTIVE_START_FIELD, EFFECTIVE_END_FIELD, NAME_FIELD, RULE_VERSION_FIELD, RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String costCategoryArn;

    private final String effectiveStart;

    private final String effectiveEnd;

    private final String name;

    private final String ruleVersion;

    private final List<CostCategoryRule> rules;

    private CostCategory(BuilderImpl builder) {
        this.costCategoryArn = builder.costCategoryArn;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.name = builder.name;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The unique identifier for your Cost Category.
     * </p>
     * 
     * @return The unique identifier for your Cost Category.
     */
    public String costCategoryArn() {
        return costCategoryArn;
    }

    /**
     * <p>
     * The Cost Category's effective start date.
     * </p>
     * 
     * @return The Cost Category's effective start date.
     */
    public String effectiveStart() {
        return effectiveStart;
    }

    /**
     * <p>
     * The Cost Category's effective end date.
     * </p>
     * 
     * @return The Cost Category's effective end date.
     */
    public String effectiveEnd() {
        return effectiveEnd;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public String name() {
        return name;
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(ruleVersion);
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public String ruleVersionAsString() {
        return ruleVersion;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to match
     * is used to determine that Cost Category value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Rules are processed in order. If there are multiple rules that match the line item, then the first rule
     *         to match is used to determine that Cost Category value.
     */
    public List<CostCategoryRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategory)) {
            return false;
        }
        CostCategory other = (CostCategory) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn())
                && Objects.equals(effectiveStart(), other.effectiveStart())
                && Objects.equals(effectiveEnd(), other.effectiveEnd()) && Objects.equals(name(), other.name())
                && Objects.equals(ruleVersionAsString(), other.ruleVersionAsString()) && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CostCategory").add("CostCategoryArn", costCategoryArn()).add("EffectiveStart", effectiveStart())
                .add("EffectiveEnd", effectiveEnd()).add("Name", name()).add("RuleVersion", ruleVersionAsString())
                .add("Rules", rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        case "EffectiveStart":
            return Optional.ofNullable(clazz.cast(effectiveStart()));
        case "EffectiveEnd":
            return Optional.ofNullable(clazz.cast(effectiveEnd()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleVersion":
            return Optional.ofNullable(clazz.cast(ruleVersionAsString()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategory, T> g) {
        return obj -> g.apply((CostCategory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostCategory> {
        /**
         * <p>
         * The unique identifier for your Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        /**
         * <p>
         * The Cost Category's effective start date.
         * </p>
         * 
         * @param effectiveStart
         *        The Cost Category's effective start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveStart(String effectiveStart);

        /**
         * <p>
         * The Cost Category's effective end date.
         * </p>
         * 
         * @param effectiveEnd
         *        The Cost Category's effective end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveEnd(String effectiveEnd);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(String ruleVersion);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(CostCategoryRuleVersion ruleVersion);

        /**
         * <p>
         * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to
         * match is used to determine that Cost Category value.
         * </p>
         * 
         * @param rules
         *        Rules are processed in order. If there are multiple rules that match the line item, then the first
         *        rule to match is used to determine that Cost Category value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<CostCategoryRule> rules);

        /**
         * <p>
         * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to
         * match is used to determine that Cost Category value.
         * </p>
         * 
         * @param rules
         *        Rules are processed in order. If there are multiple rules that match the line item, then the first
         *        rule to match is used to determine that Cost Category value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(CostCategoryRule... rules);

        /**
         * <p>
         * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to
         * match is used to determine that Cost Category value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CostCategoryRule>.Builder} avoiding the
         * need to create one manually via {@link List<CostCategoryRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategoryRule>.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<CostCategoryRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<CostCategoryRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<CostCategoryRule>)
         */
        Builder rules(Consumer<CostCategoryRule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private String costCategoryArn;

        private String effectiveStart;

        private String effectiveEnd;

        private String name;

        private String ruleVersion;

        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategory model) {
            costCategoryArn(model.costCategoryArn);
            effectiveStart(model.effectiveStart);
            effectiveEnd(model.effectiveEnd);
            name(model.name);
            ruleVersion(model.ruleVersion);
            rules(model.rules);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        public final String getEffectiveStart() {
            return effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        public final String getEffectiveEnd() {
            return effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final void setEffectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRuleVersionAsString() {
            return ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        public final Collection<CostCategoryRule.Builder> getRules() {
            return rules != null ? rules.stream().map(CostCategoryRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> CostCategoryRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public CostCategory build() {
            return new CostCategory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
