/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReportDefinitionMarshaller {
    private static final MarshallingInfo<String> REPORTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReportName").isBinary(false).build();
    private static final MarshallingInfo<String> TIMEUNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimeUnit").isBinary(false).build();
    private static final MarshallingInfo<String> FORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Format").isBinary(false).build();
    private static final MarshallingInfo<String> COMPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Compression").isBinary(false).build();
    private static final MarshallingInfo<List> ADDITIONALSCHEMAELEMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalSchemaElements").isBinary(false).build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").isBinary(false).build();
    private static final MarshallingInfo<String> S3PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Prefix").isBinary(false).build();
    private static final MarshallingInfo<String> S3REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Region").isBinary(false).build();
    private static final MarshallingInfo<List> ADDITIONALARTIFACTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalArtifacts").isBinary(false).build();
    private static final ReportDefinitionMarshaller INSTANCE = new ReportDefinitionMarshaller();

    private ReportDefinitionMarshaller() {
    }

    public static ReportDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReportDefinition reportDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reportDefinition, (String)"reportDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reportDefinition.reportName(), REPORTNAME_BINDING);
            protocolMarshaller.marshall((Object)reportDefinition.timeUnitString(), TIMEUNIT_BINDING);
            protocolMarshaller.marshall((Object)reportDefinition.formatString(), FORMAT_BINDING);
            protocolMarshaller.marshall((Object)reportDefinition.compressionString(), COMPRESSION_BINDING);
            protocolMarshaller.marshall(reportDefinition.additionalSchemaElementsStrings(), ADDITIONALSCHEMAELEMENTS_BINDING);
            protocolMarshaller.marshall((Object)reportDefinition.s3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)reportDefinition.s3Prefix(), S3PREFIX_BINDING);
            protocolMarshaller.marshall((Object)reportDefinition.s3RegionString(), S3REGION_BINDING);
            protocolMarshaller.marshall(reportDefinition.additionalArtifactsStrings(), ADDITIONALARTIFACTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

