/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.costandusagereport.CostandUsageReportClient;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsRequest;
import software.amazon.awssdk.services.costandusagereport.model.DescribeReportDefinitionsResponse;

public class DescribeReportDefinitionsIterable
implements SdkIterable<DescribeReportDefinitionsResponse> {
    private final CostandUsageReportClient client;
    private final DescribeReportDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReportDefinitionsIterable(CostandUsageReportClient client, DescribeReportDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReportDefinitionsResponseFetcher();
    }

    public Iterator<DescribeReportDefinitionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final DescribeReportDefinitionsIterable resume(DescribeReportDefinitionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReportDefinitionsIterable(this.client, (DescribeReportDefinitionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReportDefinitionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReportDefinitionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReportDefinitionsResponseFetcher
    implements SyncPageFetcher<DescribeReportDefinitionsResponse> {
        private DescribeReportDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReportDefinitionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeReportDefinitionsResponse nextPage(DescribeReportDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReportDefinitionsIterable.this.client.describeReportDefinitions(DescribeReportDefinitionsIterable.this.firstRequest);
            }
            return DescribeReportDefinitionsIterable.this.client.describeReportDefinitions((DescribeReportDefinitionsRequest)((Object)DescribeReportDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

