/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.costandusagereport.model.CostandUsageReportResponse;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinition;
import software.amazon.awssdk.services.costandusagereport.model.ReportDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReportDefinitionsResponse
extends CostandUsageReportResponse
implements ToCopyableBuilder<Builder, DescribeReportDefinitionsResponse> {
    private final List<ReportDefinition> reportDefinitions;
    private final String nextToken;

    private DescribeReportDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.reportDefinitions = builder.reportDefinitions;
        this.nextToken = builder.nextToken;
    }

    public List<ReportDefinition> reportDefinitions() {
        return this.reportDefinitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReportDefinitionsResponse)) {
            return false;
        }
        DescribeReportDefinitionsResponse other = (DescribeReportDefinitionsResponse)((Object)obj);
        return Objects.equals(this.reportDefinitions(), other.reportDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReportDefinitionsResponse").add("ReportDefinitions", this.reportDefinitions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportDefinitions": {
                return Optional.of(clazz.cast(this.reportDefinitions()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CostandUsageReportResponse.BuilderImpl
    implements Builder {
        private List<ReportDefinition> reportDefinitions;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReportDefinitionsResponse model) {
            this.reportDefinitions(model.reportDefinitions);
            this.nextToken(model.nextToken);
        }

        public final Collection<ReportDefinition.Builder> getReportDefinitions() {
            return this.reportDefinitions != null ? (Collection)this.reportDefinitions.stream().map(ReportDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reportDefinitions(Collection<ReportDefinition> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copy(reportDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportDefinitions(ReportDefinition ... reportDefinitions) {
            this.reportDefinitions(Arrays.asList(reportDefinitions));
            return this;
        }

        public final void setReportDefinitions(Collection<ReportDefinition.BuilderImpl> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copyFromBuilder(reportDefinitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeReportDefinitionsResponse build() {
            return new DescribeReportDefinitionsResponse(this);
        }
    }

    public static interface Builder
    extends CostandUsageReportResponse.Builder,
    CopyableBuilder<Builder, DescribeReportDefinitionsResponse> {
        public Builder reportDefinitions(Collection<ReportDefinition> var1);

        public Builder reportDefinitions(ReportDefinition ... var1);

        public Builder nextToken(String var1);
    }
}

