/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.costandusagereport.model.AWSRegion;
import software.amazon.awssdk.services.costandusagereport.model.AdditionalArtifact;
import software.amazon.awssdk.services.costandusagereport.model.AdditionalArtifactListCopier;
import software.amazon.awssdk.services.costandusagereport.model.CompressionFormat;
import software.amazon.awssdk.services.costandusagereport.model.ReportFormat;
import software.amazon.awssdk.services.costandusagereport.model.SchemaElement;
import software.amazon.awssdk.services.costandusagereport.model.SchemaElementListCopier;
import software.amazon.awssdk.services.costandusagereport.model.TimeUnit;
import software.amazon.awssdk.services.costandusagereport.transform.ReportDefinitionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReportDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, ReportDefinition> {
    private final String reportName;
    private final String timeUnit;
    private final String format;
    private final String compression;
    private final List<String> additionalSchemaElements;
    private final String s3Bucket;
    private final String s3Prefix;
    private final String s3Region;
    private final List<String> additionalArtifacts;

    private ReportDefinition(BuilderImpl builder) {
        this.reportName = builder.reportName;
        this.timeUnit = builder.timeUnit;
        this.format = builder.format;
        this.compression = builder.compression;
        this.additionalSchemaElements = builder.additionalSchemaElements;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.s3Region = builder.s3Region;
        this.additionalArtifacts = builder.additionalArtifacts;
    }

    public String reportName() {
        return this.reportName;
    }

    public TimeUnit timeUnit() {
        return TimeUnit.fromValue(this.timeUnit);
    }

    public String timeUnitString() {
        return this.timeUnit;
    }

    public ReportFormat format() {
        return ReportFormat.fromValue(this.format);
    }

    public String formatString() {
        return this.format;
    }

    public CompressionFormat compression() {
        return CompressionFormat.fromValue(this.compression);
    }

    public String compressionString() {
        return this.compression;
    }

    public List<SchemaElement> additionalSchemaElements() {
        return TypeConverter.convert(this.additionalSchemaElements, SchemaElement::fromValue);
    }

    public List<String> additionalSchemaElementsStrings() {
        return this.additionalSchemaElements;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Prefix() {
        return this.s3Prefix;
    }

    public AWSRegion s3Region() {
        return AWSRegion.fromValue(this.s3Region);
    }

    public String s3RegionString() {
        return this.s3Region;
    }

    public List<AdditionalArtifact> additionalArtifacts() {
        return TypeConverter.convert(this.additionalArtifacts, AdditionalArtifact::fromValue);
    }

    public List<String> additionalArtifactsStrings() {
        return this.additionalArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reportName() == null ? 0 : this.reportName().hashCode());
        hashCode = 31 * hashCode + (this.timeUnitString() == null ? 0 : this.timeUnitString().hashCode());
        hashCode = 31 * hashCode + (this.formatString() == null ? 0 : this.formatString().hashCode());
        hashCode = 31 * hashCode + (this.compressionString() == null ? 0 : this.compressionString().hashCode());
        hashCode = 31 * hashCode + (this.additionalSchemaElementsStrings() == null ? 0 : this.additionalSchemaElementsStrings().hashCode());
        hashCode = 31 * hashCode + (this.s3Bucket() == null ? 0 : this.s3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.s3Prefix() == null ? 0 : this.s3Prefix().hashCode());
        hashCode = 31 * hashCode + (this.s3RegionString() == null ? 0 : this.s3RegionString().hashCode());
        hashCode = 31 * hashCode + (this.additionalArtifactsStrings() == null ? 0 : this.additionalArtifactsStrings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition)obj;
        if (other.reportName() == null ^ this.reportName() == null) {
            return false;
        }
        if (other.reportName() != null && !other.reportName().equals(this.reportName())) {
            return false;
        }
        if (other.timeUnitString() == null ^ this.timeUnitString() == null) {
            return false;
        }
        if (other.timeUnitString() != null && !other.timeUnitString().equals(this.timeUnitString())) {
            return false;
        }
        if (other.formatString() == null ^ this.formatString() == null) {
            return false;
        }
        if (other.formatString() != null && !other.formatString().equals(this.formatString())) {
            return false;
        }
        if (other.compressionString() == null ^ this.compressionString() == null) {
            return false;
        }
        if (other.compressionString() != null && !other.compressionString().equals(this.compressionString())) {
            return false;
        }
        if (other.additionalSchemaElementsStrings() == null ^ this.additionalSchemaElementsStrings() == null) {
            return false;
        }
        if (other.additionalSchemaElementsStrings() != null && !other.additionalSchemaElementsStrings().equals(this.additionalSchemaElementsStrings())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3Prefix() == null ^ this.s3Prefix() == null) {
            return false;
        }
        if (other.s3Prefix() != null && !other.s3Prefix().equals(this.s3Prefix())) {
            return false;
        }
        if (other.s3RegionString() == null ^ this.s3RegionString() == null) {
            return false;
        }
        if (other.s3RegionString() != null && !other.s3RegionString().equals(this.s3RegionString())) {
            return false;
        }
        if (other.additionalArtifactsStrings() == null ^ this.additionalArtifactsStrings() == null) {
            return false;
        }
        return other.additionalArtifactsStrings() == null || other.additionalArtifactsStrings().equals(this.additionalArtifactsStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.reportName() != null) {
            sb.append("ReportName: ").append(this.reportName()).append(",");
        }
        if (this.timeUnitString() != null) {
            sb.append("TimeUnit: ").append(this.timeUnitString()).append(",");
        }
        if (this.formatString() != null) {
            sb.append("Format: ").append(this.formatString()).append(",");
        }
        if (this.compressionString() != null) {
            sb.append("Compression: ").append(this.compressionString()).append(",");
        }
        if (this.additionalSchemaElementsStrings() != null) {
            sb.append("AdditionalSchemaElements: ").append(this.additionalSchemaElementsStrings()).append(",");
        }
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3Prefix() != null) {
            sb.append("S3Prefix: ").append(this.s3Prefix()).append(",");
        }
        if (this.s3RegionString() != null) {
            sb.append("S3Region: ").append(this.s3RegionString()).append(",");
        }
        if (this.additionalArtifactsStrings() != null) {
            sb.append("AdditionalArtifacts: ").append(this.additionalArtifactsStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportName": {
                return Optional.of(clazz.cast(this.reportName()));
            }
            case "TimeUnit": {
                return Optional.of(clazz.cast(this.timeUnitString()));
            }
            case "Format": {
                return Optional.of(clazz.cast(this.formatString()));
            }
            case "Compression": {
                return Optional.of(clazz.cast(this.compressionString()));
            }
            case "AdditionalSchemaElements": {
                return Optional.of(clazz.cast(this.additionalSchemaElementsStrings()));
            }
            case "S3Bucket": {
                return Optional.of(clazz.cast(this.s3Bucket()));
            }
            case "S3Prefix": {
                return Optional.of(clazz.cast(this.s3Prefix()));
            }
            case "S3Region": {
                return Optional.of(clazz.cast(this.s3RegionString()));
            }
            case "AdditionalArtifacts": {
                return Optional.of(clazz.cast(this.additionalArtifactsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportName;
        private String timeUnit;
        private String format;
        private String compression;
        private List<String> additionalSchemaElements;
        private String s3Bucket;
        private String s3Prefix;
        private String s3Region;
        private List<String> additionalArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDefinition model) {
            this.reportName(model.reportName);
            this.timeUnit(model.timeUnit);
            this.format(model.format);
            this.compression(model.compression);
            this.additionalSchemaElements(model.additionalSchemaElements);
            this.s3Bucket(model.s3Bucket);
            this.s3Prefix(model.s3Prefix);
            this.s3Region(model.s3Region);
            this.additionalArtifacts(model.additionalArtifacts);
        }

        public final String getReportName() {
            return this.reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        public final String getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
            return this;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ReportFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getCompression() {
            return this.compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(CompressionFormat compression) {
            this.compression(compression.toString());
            return this;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        public final Collection<String> getAdditionalSchemaElements() {
            return this.additionalSchemaElements;
        }

        @Override
        public final Builder additionalSchemaElements(Collection<String> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copy(additionalSchemaElements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSchemaElements(String ... additionalSchemaElements) {
            this.additionalSchemaElements(Arrays.asList(additionalSchemaElements));
            return this;
        }

        public final void setAdditionalSchemaElements(Collection<String> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copy(additionalSchemaElements);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getS3Region() {
            return this.s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        @Override
        public final Builder s3Region(AWSRegion s3Region) {
            this.s3Region(s3Region.toString());
            return this;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        public final Collection<String> getAdditionalArtifacts() {
            return this.additionalArtifacts;
        }

        @Override
        public final Builder additionalArtifacts(Collection<String> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copy(additionalArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifacts(String ... additionalArtifacts) {
            this.additionalArtifacts(Arrays.asList(additionalArtifacts));
            return this;
        }

        public final void setAdditionalArtifacts(Collection<String> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copy(additionalArtifacts);
        }

        public ReportDefinition build() {
            return new ReportDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReportDefinition> {
        public Builder reportName(String var1);

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder format(String var1);

        public Builder format(ReportFormat var1);

        public Builder compression(String var1);

        public Builder compression(CompressionFormat var1);

        public Builder additionalSchemaElements(Collection<String> var1);

        public Builder additionalSchemaElements(String ... var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3Region(String var1);

        public Builder s3Region(AWSRegion var1);

        public Builder additionalArtifacts(Collection<String> var1);

        public Builder additionalArtifacts(String ... var1);
    }
}

