/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.costandusagereport.model.AWSRegion;
import software.amazon.awssdk.services.costandusagereport.model.AdditionalArtifact;
import software.amazon.awssdk.services.costandusagereport.model.AdditionalArtifactListCopier;
import software.amazon.awssdk.services.costandusagereport.model.CompressionFormat;
import software.amazon.awssdk.services.costandusagereport.model.ReportFormat;
import software.amazon.awssdk.services.costandusagereport.model.SchemaElement;
import software.amazon.awssdk.services.costandusagereport.model.SchemaElementListCopier;
import software.amazon.awssdk.services.costandusagereport.model.TimeUnit;
import software.amazon.awssdk.services.costandusagereport.transform.ReportDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, ReportDefinition> {
    private final String reportName;
    private final String timeUnit;
    private final String format;
    private final String compression;
    private final List<String> additionalSchemaElements;
    private final String s3Bucket;
    private final String s3Prefix;
    private final String s3Region;
    private final List<String> additionalArtifacts;

    private ReportDefinition(BuilderImpl builder) {
        this.reportName = builder.reportName;
        this.timeUnit = builder.timeUnit;
        this.format = builder.format;
        this.compression = builder.compression;
        this.additionalSchemaElements = builder.additionalSchemaElements;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.s3Region = builder.s3Region;
        this.additionalArtifacts = builder.additionalArtifacts;
    }

    public String reportName() {
        return this.reportName;
    }

    public TimeUnit timeUnit() {
        return TimeUnit.fromValue(this.timeUnit);
    }

    public String timeUnitAsString() {
        return this.timeUnit;
    }

    public ReportFormat format() {
        return ReportFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public CompressionFormat compression() {
        return CompressionFormat.fromValue(this.compression);
    }

    public String compressionAsString() {
        return this.compression;
    }

    public List<SchemaElement> additionalSchemaElements() {
        return TypeConverter.convert(this.additionalSchemaElements, SchemaElement::fromValue);
    }

    public List<String> additionalSchemaElementsAsStrings() {
        return this.additionalSchemaElements;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3Prefix() {
        return this.s3Prefix;
    }

    public AWSRegion s3Region() {
        return AWSRegion.fromValue(this.s3Region);
    }

    public String s3RegionAsString() {
        return this.s3Region;
    }

    public List<AdditionalArtifact> additionalArtifacts() {
        return TypeConverter.convert(this.additionalArtifacts, AdditionalArtifact::fromValue);
    }

    public List<String> additionalArtifactsAsStrings() {
        return this.additionalArtifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalSchemaElementsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3RegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalArtifactsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportDefinition)) {
            return false;
        }
        ReportDefinition other = (ReportDefinition)obj;
        return Objects.equals(this.reportName(), other.reportName()) && Objects.equals(this.timeUnitAsString(), other.timeUnitAsString()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.compressionAsString(), other.compressionAsString()) && Objects.equals(this.additionalSchemaElementsAsStrings(), other.additionalSchemaElementsAsStrings()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3RegionAsString(), other.s3RegionAsString()) && Objects.equals(this.additionalArtifactsAsStrings(), other.additionalArtifactsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ReportDefinition").add("ReportName", (Object)this.reportName()).add("TimeUnit", (Object)this.timeUnitAsString()).add("Format", (Object)this.formatAsString()).add("Compression", (Object)this.compressionAsString()).add("AdditionalSchemaElements", this.additionalSchemaElementsAsStrings()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Prefix", (Object)this.s3Prefix()).add("S3Region", (Object)this.s3RegionAsString()).add("AdditionalArtifacts", this.additionalArtifactsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportName": {
                return Optional.ofNullable(clazz.cast(this.reportName()));
            }
            case "TimeUnit": {
                return Optional.ofNullable(clazz.cast(this.timeUnitAsString()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Compression": {
                return Optional.ofNullable(clazz.cast(this.compressionAsString()));
            }
            case "AdditionalSchemaElements": {
                return Optional.ofNullable(clazz.cast(this.additionalSchemaElementsAsStrings()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3Region": {
                return Optional.ofNullable(clazz.cast(this.s3RegionAsString()));
            }
            case "AdditionalArtifacts": {
                return Optional.ofNullable(clazz.cast(this.additionalArtifactsAsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportName;
        private String timeUnit;
        private String format;
        private String compression;
        private List<String> additionalSchemaElements = DefaultSdkAutoConstructList.getInstance();
        private String s3Bucket;
        private String s3Prefix;
        private String s3Region;
        private List<String> additionalArtifacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportDefinition model) {
            this.reportName(model.reportName);
            this.timeUnit(model.timeUnit);
            this.format(model.format);
            this.compression(model.compression);
            this.additionalSchemaElementsWithStrings(model.additionalSchemaElements);
            this.s3Bucket(model.s3Bucket);
            this.s3Prefix(model.s3Prefix);
            this.s3Region(model.s3Region);
            this.additionalArtifactsWithStrings(model.additionalArtifacts);
        }

        public final String getReportName() {
            return this.reportName;
        }

        @Override
        public final Builder reportName(String reportName) {
            this.reportName = reportName;
            return this;
        }

        public final void setReportName(String reportName) {
            this.reportName = reportName;
        }

        public final String getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        public final Builder timeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        @Override
        public final Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit(timeUnit.toString());
            return this;
        }

        public final void setTimeUnit(String timeUnit) {
            this.timeUnit = timeUnit;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ReportFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getCompression() {
            return this.compression;
        }

        @Override
        public final Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        @Override
        public final Builder compression(CompressionFormat compression) {
            this.compression(compression.toString());
            return this;
        }

        public final void setCompression(String compression) {
            this.compression = compression;
        }

        public final Collection<String> getAdditionalSchemaElements() {
            return this.additionalSchemaElements;
        }

        @Override
        public final Builder additionalSchemaElementsWithStrings(Collection<String> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copy(additionalSchemaElements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSchemaElementsWithStrings(String ... additionalSchemaElements) {
            this.additionalSchemaElementsWithStrings(Arrays.asList(additionalSchemaElements));
            return this;
        }

        @Override
        public final Builder additionalSchemaElements(Collection<SchemaElement> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copyEnumToString(additionalSchemaElements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalSchemaElements(SchemaElement ... additionalSchemaElements) {
            this.additionalSchemaElements(Arrays.asList(additionalSchemaElements));
            return this;
        }

        public final void setAdditionalSchemaElements(Collection<String> additionalSchemaElements) {
            this.additionalSchemaElements = SchemaElementListCopier.copy(additionalSchemaElements);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getS3Region() {
            return this.s3Region;
        }

        @Override
        public final Builder s3Region(String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        @Override
        public final Builder s3Region(AWSRegion s3Region) {
            this.s3Region(s3Region.toString());
            return this;
        }

        public final void setS3Region(String s3Region) {
            this.s3Region = s3Region;
        }

        public final Collection<String> getAdditionalArtifacts() {
            return this.additionalArtifacts;
        }

        @Override
        public final Builder additionalArtifactsWithStrings(Collection<String> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copy(additionalArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifactsWithStrings(String ... additionalArtifacts) {
            this.additionalArtifactsWithStrings(Arrays.asList(additionalArtifacts));
            return this;
        }

        @Override
        public final Builder additionalArtifacts(Collection<AdditionalArtifact> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copyEnumToString(additionalArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifacts(AdditionalArtifact ... additionalArtifacts) {
            this.additionalArtifacts(Arrays.asList(additionalArtifacts));
            return this;
        }

        public final void setAdditionalArtifacts(Collection<String> additionalArtifacts) {
            this.additionalArtifacts = AdditionalArtifactListCopier.copy(additionalArtifacts);
        }

        public ReportDefinition build() {
            return new ReportDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReportDefinition> {
        public Builder reportName(String var1);

        public Builder timeUnit(String var1);

        public Builder timeUnit(TimeUnit var1);

        public Builder format(String var1);

        public Builder format(ReportFormat var1);

        public Builder compression(String var1);

        public Builder compression(CompressionFormat var1);

        public Builder additionalSchemaElementsWithStrings(Collection<String> var1);

        public Builder additionalSchemaElementsWithStrings(String ... var1);

        public Builder additionalSchemaElements(Collection<SchemaElement> var1);

        public Builder additionalSchemaElements(SchemaElement ... var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3Region(String var1);

        public Builder s3Region(AWSRegion var1);

        public Builder additionalArtifactsWithStrings(Collection<String> var1);

        public Builder additionalArtifactsWithStrings(String ... var1);

        public Builder additionalArtifacts(Collection<AdditionalArtifact> var1);

        public Builder additionalArtifacts(AdditionalArtifact ... var1);
    }
}

