/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.waiters;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.util.ValidationUtils;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;
import software.amazon.awssdk.waiters.WaiterExecution;
import software.amazon.awssdk.waiters.WaiterExecutionBuilder;
import software.amazon.awssdk.waiters.WaiterHandler;
import software.amazon.awssdk.waiters.WaiterParameters;
import software.amazon.awssdk.waiters.WaiterTimedOutException;
import software.amazon.awssdk.waiters.WaiterUnrecoverableException;

@SdkProtectedApi
public class WaiterImpl<InputT extends AmazonWebServiceRequest, OutputT>
implements Waiter<InputT> {
    private final SdkFunction<InputT, OutputT> sdkFunction;
    private final List<WaiterAcceptor<OutputT>> acceptors;
    private final PollingStrategy defaultPollingStrategy;
    private final ExecutorService executorService;

    @SdkProtectedApi
    public WaiterImpl(WaiterBuilder<InputT, OutputT> waiterBuilder) {
        this.sdkFunction = ValidationUtils.assertNotNull(waiterBuilder.getSdkFunction(), "sdkFunction");
        this.acceptors = ValidationUtils.assertNotNull(waiterBuilder.getAcceptor(), "acceptors");
        this.defaultPollingStrategy = ValidationUtils.assertNotNull(waiterBuilder.getDefaultPollingStrategy(), "defaultPollingStrategy");
        this.executorService = ValidationUtils.assertNotNull(waiterBuilder.getExecutorService(), "executorService");
    }

    @Override
    public void run(WaiterParameters<InputT> waiterParameters) throws AmazonServiceException, WaiterTimedOutException, WaiterUnrecoverableException {
        ValidationUtils.assertNotNull(waiterParameters, "waiterParameters");
        AmazonWebServiceRequest request = ((AmazonWebServiceRequest)ValidationUtils.assertNotNull(waiterParameters.getRequest(), "request")).clone();
        request.getRequestClientOptions().appendUserAgent("waiter-request");
        WaiterExecution waiterExecution = new WaiterExecutionBuilder().withRequest(request).withPollingStrategy(waiterParameters.getPollingStrategy() != null ? waiterParameters.getPollingStrategy() : this.defaultPollingStrategy).withAcceptors(this.acceptors).withSdkFunction(this.sdkFunction).build();
        waiterExecution.pollResource();
    }

    @Override
    public Future<Void> runAsync(WaiterParameters<InputT> waiterParameters, WaiterHandler callback) throws AmazonServiceException, WaiterTimedOutException, WaiterUnrecoverableException {
        return this.executorService.submit(() -> {
            try {
                this.run(waiterParameters);
                callback.onWaitSuccess(waiterParameters.getRequest());
            }
            catch (Exception ex) {
                callback.onWaitFailure(ex);
                throw ex;
            }
            return null;
        });
    }
}

