/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.waiters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.SdkProtectedApi;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterImpl;

@SdkProtectedApi
public class WaiterBuilder<InputT extends AmazonWebServiceRequest, OutputT> {
    private SdkFunction<InputT, OutputT> sdkFunction;
    private List<WaiterAcceptor<OutputT>> acceptors = new ArrayList<WaiterAcceptor<OutputT>>();
    private PollingStrategy defaultPollingStrategy;
    private ExecutorService executorService;

    public WaiterBuilder<InputT, OutputT> withSdkFunction(SdkFunction<InputT, OutputT> sdkFunction) {
        this.sdkFunction = sdkFunction;
        return this;
    }

    public WaiterBuilder<InputT, OutputT> withAcceptors(WaiterAcceptor<OutputT> ... acceptors) {
        Collections.addAll(this.acceptors, acceptors);
        return this;
    }

    public WaiterBuilder<InputT, OutputT> withDefaultPollingStrategy(PollingStrategy pollingStrategy) {
        this.defaultPollingStrategy = pollingStrategy;
        return this;
    }

    public WaiterBuilder<InputT, OutputT> withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public List<WaiterAcceptor<OutputT>> getAcceptor() {
        return this.acceptors;
    }

    public SdkFunction<InputT, OutputT> getSdkFunction() {
        return this.sdkFunction;
    }

    PollingStrategy getDefaultPollingStrategy() {
        return this.defaultPollingStrategy;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Waiter<InputT> build() {
        return new WaiterImpl(this);
    }
}

