/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.runtime.transform;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Date;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.util.DateUtils;

@SdkInternalApi
public class SimpleTypeCborUnmarshallers {

    public static class ShortCborUnmarshaller
    implements Unmarshaller<Short, JsonUnmarshallerContext> {
        private static final ShortCborUnmarshaller INSTANCE = new ShortCborUnmarshaller();

        public static ShortCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Short unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getJsonParser().getShortValue();
        }
    }

    public static class InstantCborUnmarshaller
    implements Unmarshaller<Instant, JsonUnmarshallerContext> {
        private static final InstantCborUnmarshaller INSTANCE = new InstantCborUnmarshaller();

        public static InstantCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Instant unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            Date date = DateUtils.parseServiceSpecificDate(unmarshallerContext.readText());
            if (date == null) {
                return null;
            }
            return date.toInstant();
        }
    }

    public static class ByteBufferCborUnmarshaller
    implements Unmarshaller<ByteBuffer, JsonUnmarshallerContext> {
        private static final ByteBufferCborUnmarshaller INSTANCE = new ByteBufferCborUnmarshaller();

        public static ByteBufferCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public ByteBuffer unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return ByteBuffer.wrap(unmarshallerContext.getJsonParser().getBinaryValue());
        }
    }

    public static class DateCborUnmarshaller
    implements Unmarshaller<Date, JsonUnmarshallerContext> {
        private static final DateCborUnmarshaller INSTANCE = new DateCborUnmarshaller();

        public static DateCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Date unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return new Date(unmarshallerContext.getJsonParser().getLongValue());
        }
    }

    public static class ByteCborUnmarshaller
    implements Unmarshaller<Byte, JsonUnmarshallerContext> {
        private static final ByteCborUnmarshaller INSTANCE = new ByteCborUnmarshaller();

        public static ByteCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Byte unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getJsonParser().getByteValue();
        }
    }

    public static class LongCborUnmarshaller
    implements Unmarshaller<Long, JsonUnmarshallerContext> {
        private static final LongCborUnmarshaller INSTANCE = new LongCborUnmarshaller();

        public static LongCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Long unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getJsonParser().getLongValue();
        }
    }

    public static class FloatCborUnmarshaller
    implements Unmarshaller<Float, JsonUnmarshallerContext> {
        private static final FloatCborUnmarshaller INSTANCE = new FloatCborUnmarshaller();

        public static FloatCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Float unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return Float.valueOf(unmarshallerContext.getJsonParser().getFloatValue());
        }
    }

    public static class BooleanCborUnmarshaller
    implements Unmarshaller<Boolean, JsonUnmarshallerContext> {
        private static final BooleanCborUnmarshaller INSTANCE = new BooleanCborUnmarshaller();

        public static BooleanCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Boolean unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getJsonParser().getBooleanValue();
        }
    }

    public static class BigDecimalCborUnmarshaller
    implements Unmarshaller<BigDecimal, JsonUnmarshallerContext> {
        private static final BigDecimalCborUnmarshaller INSTANCE = new BigDecimalCborUnmarshaller();

        public static BigDecimalCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public BigDecimal unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            JsonParser parser = unmarshallerContext.getJsonParser();
            Unmarshaller<BigInteger, JsonUnmarshallerContext> bigIntegerUnmarshaller = unmarshallerContext.getUnmarshaller(BigInteger.class);
            JsonToken current = parser.getCurrentToken();
            if (current != JsonToken.START_ARRAY) {
                throw new SdkClientException("Invalid BigDecimal Format.");
            }
            parser.nextToken();
            int exponent = parser.getIntValue();
            parser.nextToken();
            BigInteger mantissa = bigIntegerUnmarshaller.unmarshall(unmarshallerContext);
            return new BigDecimal(mantissa, exponent);
        }
    }

    public static class BigIntegerCborUnmarshaller
    implements Unmarshaller<BigInteger, JsonUnmarshallerContext> {
        private static final BigIntegerCborUnmarshaller INSTANCE = new BigIntegerCborUnmarshaller();

        public static BigIntegerCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public BigInteger unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            JsonParser parser = unmarshallerContext.getJsonParser();
            JsonToken current = parser.getCurrentToken();
            if (current == JsonToken.VALUE_NUMBER_INT) {
                return parser.getBigIntegerValue();
            }
            if (current == JsonToken.VALUE_EMBEDDED_OBJECT) {
                Object embedded = parser.getEmbeddedObject();
                return new BigInteger((byte[])embedded);
            }
            throw new SdkClientException("Invalid BigInteger Format.");
        }
    }

    public static class IntegerCborUnmarshaller
    implements Unmarshaller<Integer, JsonUnmarshallerContext> {
        private static final IntegerCborUnmarshaller INSTANCE = new IntegerCborUnmarshaller();

        public static IntegerCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Integer unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getJsonParser().getIntValue();
        }
    }

    public static class DoubleCborUnmarshaller
    implements Unmarshaller<Double, JsonUnmarshallerContext> {
        private static final DoubleCborUnmarshaller INSTANCE = new DoubleCborUnmarshaller();

        public static DoubleCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public Double unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.getJsonParser().getDoubleValue();
        }
    }

    public static class StringCborUnmarshaller
    implements Unmarshaller<String, JsonUnmarshallerContext> {
        private static final StringCborUnmarshaller INSTANCE = new StringCborUnmarshaller();

        public static StringCborUnmarshaller getInstance() {
            return INSTANCE;
        }

        @Override
        public String unmarshall(JsonUnmarshallerContext unmarshallerContext) throws Exception {
            return unmarshallerContext.readText();
        }
    }
}

