/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.RequestClientOptions;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.metrics.RequestMetricCollector;

@SdkInternalApi
public final class AmazonWebServiceRequestAdapter
extends RequestConfig {
    private final AmazonWebServiceRequest request;

    public AmazonWebServiceRequestAdapter(AmazonWebServiceRequest request) {
        this.request = request;
    }

    @Override
    public ProgressListener getProgressListener() {
        return this.request.getGeneralProgressListener();
    }

    @Override
    public RequestMetricCollector getRequestMetricsCollector() {
        return this.request.getRequestMetricCollector();
    }

    @Override
    public AwsCredentialsProvider getCredentialsProvider() {
        return this.request.getRequestCredentialsProvider();
    }

    @Override
    public Map<String, String> getCustomRequestHeaders() {
        return this.request.getCustomRequestHeaders() == null ? Collections.emptyMap() : this.request.getCustomRequestHeaders();
    }

    @Override
    public Map<String, List<String>> getCustomQueryParameters() {
        return this.request.getCustomQueryParameters() == null ? Collections.emptyMap() : this.request.getCustomQueryParameters();
    }

    @Override
    public Integer getClientExecutionTimeout() {
        return this.request.getSdkClientExecutionTimeout();
    }

    @Override
    public RequestClientOptions getRequestClientOptions() {
        return this.request.getRequestClientOptions();
    }

    @Override
    public String getRequestType() {
        return this.request.getClass().getSimpleName();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }
}

