/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.event.ProgressEventType;
import software.amazon.awssdk.event.ProgressListener;
import software.amazon.awssdk.event.SdkProgressPublisher;
import software.amazon.awssdk.http.Abortable;
import software.amazon.awssdk.http.AbortableCallable;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.HttpClientDependencies;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.http.pipeline.RequestPipeline;
import software.amazon.awssdk.utils.Pair;

public class MakeHttpRequestStage
implements RequestPipeline<SdkHttpFullRequest, Pair<SdkHttpFullRequest, SdkHttpFullResponse>> {
    private final SdkHttpClient sdkHttpClient;

    public MakeHttpRequestStage(HttpClientDependencies dependencies) {
        this.sdkHttpClient = dependencies.sdkHttpClient();
    }

    @Override
    public Pair<SdkHttpFullRequest, SdkHttpFullResponse> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        AmazonHttpClient.checkInterrupted();
        ProgressListener listener = context.requestConfig().getProgressListener();
        SdkProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_REQUEST_STARTED_EVENT);
        SdkHttpFullResponse httpResponse = this.executeHttpRequest(request, context);
        SdkProgressPublisher.publishProgress(listener, ProgressEventType.HTTP_REQUEST_COMPLETED_EVENT);
        return new Pair((Object)request, (Object)httpResponse);
    }

    private SdkHttpFullResponse executeHttpRequest(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        AbortableCallable requestCallable = this.sdkHttpClient.prepareRequest(request, SdkRequestContext.builder().metrics(context.awsRequestMetrics()).build());
        context.getClientExecutionTrackerTask().setCurrentHttpRequest((Abortable)requestCallable);
        return (SdkHttpFullResponse)requestCallable.call();
    }
}

