/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import java.util.Optional;
import software.amazon.awssdk.AbortedException;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.http.HttpClientDependencies;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.exception.ClientExecutionTimeoutException;
import software.amazon.awssdk.http.exception.SdkInterruptedException;
import software.amazon.awssdk.http.pipeline.RequestPipeline;
import software.amazon.awssdk.http.pipeline.RequestToResponsePipeline;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionTimer;
import software.amazon.awssdk.utils.FunctionalUtils;

public class ClientExecutionTimedStage<OutputT>
implements RequestToResponsePipeline<OutputT> {
    private final RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped;
    private final ClientExecutionTimer clientExecutionTimer;
    private final LegacyClientConfiguration config;

    public ClientExecutionTimedStage(HttpClientDependencies dependencies, RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped) {
        this.wrapped = wrapped;
        this.clientExecutionTimer = dependencies.clientExecutionTimer();
        this.config = dependencies.config();
    }

    @Override
    public Response<OutputT> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        try {
            return this.executeWithTimer(request, context);
        }
        catch (InterruptedException ie) {
            throw this.handleInterruptedException(context, ie);
        }
        catch (AbortedException ae) {
            throw this.handleAbortedException(context, ae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response<OutputT> executeWithTimer(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        try {
            context.setClientExecutionTrackerTask(this.clientExecutionTimer.startTimer(this.getClientExecutionTimeout(context.requestConfig())));
            Response<OutputT> response = this.wrapped.execute(request, context);
            return response;
        }
        finally {
            context.getClientExecutionTrackerTask().cancelTask();
        }
    }

    private RuntimeException handleInterruptedException(RequestExecutionContext context, InterruptedException e) {
        if (e instanceof SdkInterruptedException) {
            Optional.ofNullable(((SdkInterruptedException)e).getResponse()).map(Response::getHttpResponse).map(HttpResponse::getContent).ifPresent(r -> FunctionalUtils.invokeSafely(r::close));
        }
        if (context.getClientExecutionTrackerTask().hasTimeoutExpired()) {
            Thread.interrupted();
            return new ClientExecutionTimeoutException();
        }
        Thread.currentThread().interrupt();
        return new AbortedException(e);
    }

    private RuntimeException handleAbortedException(RequestExecutionContext context, AbortedException ae) {
        if (context.getClientExecutionTrackerTask().hasTimeoutExpired()) {
            return new ClientExecutionTimeoutException();
        }
        return ae;
    }

    private int getClientExecutionTimeout(RequestConfig requestConfig) {
        if (requestConfig.getClientExecutionTimeout() != null) {
            return requestConfig.getClientExecutionTimeout();
        }
        return this.config.getClientExecutionTimeout();
    }
}

