/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.RequestClientOptions;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.http.HttpClientDependencies;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.pipeline.MutableRequestToRequestPipeline;
import software.amazon.awssdk.util.RuntimeHttpUtils;

public class ApplyUserAgentStage
implements MutableRequestToRequestPipeline {
    private final LegacyClientConfiguration config;

    public ApplyUserAgentStage(HttpClientDependencies dependencies) {
        this.config = dependencies.config();
    }

    @Override
    public SdkHttpFullRequest.Builder execute(SdkHttpFullRequest.Builder request, RequestExecutionContext context) throws Exception {
        RequestClientOptions opts = context.requestConfig().getRequestClientOptions();
        if (opts != null) {
            return request.header("User-Agent", RuntimeHttpUtils.getUserAgent(this.config, opts.getClientMarker(RequestClientOptions.Marker.USER_AGENT)));
        }
        return request.header("User-Agent", RuntimeHttpUtils.getUserAgent(this.config, null));
    }
}

