/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.pipeline.stages;

import java.util.List;
import software.amazon.awssdk.RequestExecutionContext;
import software.amazon.awssdk.Response;
import software.amazon.awssdk.event.ProgressEventType;
import software.amazon.awssdk.event.SdkProgressPublisher;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.AmazonHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.pipeline.RequestPipeline;
import software.amazon.awssdk.http.pipeline.RequestToResponsePipeline;

public class AfterCallbackStage<OutputT>
implements RequestToResponsePipeline<OutputT> {
    private final RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped;

    public AfterCallbackStage(RequestPipeline<SdkHttpFullRequest, Response<OutputT>> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Response<OutputT> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        Response<OutputT> response = null;
        try {
            response = this.wrapped.execute(request, context);
            this.afterResponse(context.requestHandlers(), request, response);
            return response;
        }
        catch (Exception e) {
            SdkProgressPublisher.publishProgress(context.requestConfig().getProgressListener(), ProgressEventType.CLIENT_REQUEST_FAILED_EVENT);
            this.afterError(context.requestHandlers(), request, response, e);
            throw e;
        }
    }

    private <T> void afterResponse(List<RequestHandler> requestHandlers, SdkHttpFullRequest request, Response<T> response) throws InterruptedException {
        for (RequestHandler handler : requestHandlers) {
            handler.afterResponse(request, response);
            AmazonHttpClient.checkInterrupted(response);
        }
    }

    private void afterError(List<RequestHandler> requestHandlers, SdkHttpFullRequest request, Response<?> response, Exception e) throws InterruptedException {
        for (RequestHandler handler : requestHandlers) {
            handler.afterError(request, response, e);
            AmazonHttpClient.checkInterrupted(response);
        }
    }
}

