/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.async;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.http.HttpResponse;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.async.SimpleSubscriber;
import software.amazon.awssdk.util.Throwables;
import software.amazon.awssdk.utils.BinaryUtils;

public class SyncResponseHandlerAdapter<T>
implements SdkHttpResponseHandler<T> {
    private final HttpResponseHandler<T> responseHandler;
    private ByteArrayOutputStream baos;
    private final Function<SdkHttpFullResponse, HttpResponse> httpResponseAdapter;
    private HttpResponse httpResponse;

    public SyncResponseHandlerAdapter(HttpResponseHandler<T> responseHandler, Function<SdkHttpFullResponse, HttpResponse> httpResponseAdapter) {
        this.responseHandler = responseHandler;
        this.httpResponseAdapter = httpResponseAdapter;
    }

    public void headersReceived(SdkHttpResponse response) {
        this.httpResponse = this.httpResponseAdapter.apply((SdkHttpFullResponse)response);
    }

    public void onStream(Publisher<ByteBuffer> publisher) {
        this.baos = new ByteArrayOutputStream();
        publisher.subscribe((Subscriber)new SimpleSubscriber(b -> {
            try {
                this.baos.write(BinaryUtils.copyBytesFrom((ByteBuffer)b));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
    }

    public void exceptionOccurred(Throwable throwable) {
    }

    public T complete() {
        try {
            if (this.baos != null) {
                this.httpResponse.setContent(new ByteArrayInputStream(this.baos.toByteArray()));
            }
            return this.responseHandler.handle(this.httpResponse);
        }
        catch (Exception e) {
            throw Throwables.failure(e);
        }
    }
}

