/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.concurrent.ScheduledExecutorService;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.SdkGlobalTime;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.internal.http.timers.client.ClientExecutionTimer;
import software.amazon.awssdk.retry.v2.RetryPolicy;
import software.amazon.awssdk.util.CapacityManager;
import software.amazon.awssdk.utils.Validate;

public class HttpClientDependencies
implements AutoCloseable {
    private final LegacyClientConfiguration config;
    private final RetryPolicy retryPolicy;
    private final CapacityManager retryCapacity;
    private final SdkHttpClient sdkHttpClient;
    private final SdkAsyncHttpClient sdkAsyncHttpClient;
    private final ClientExecutionTimer clientExecutionTimer;
    private final ScheduledExecutorService executorService;
    private final boolean calculateCrc32FromCompressedData;
    private volatile int timeOffset = SdkGlobalTime.getGlobalTimeOffset();

    private HttpClientDependencies(Builder builder) {
        this.config = (LegacyClientConfiguration)Validate.paramNotNull((Object)builder.config, (String)"Configuration");
        this.retryPolicy = (RetryPolicy)Validate.paramNotNull((Object)builder.retryPolicy, (String)"RetryPolicy");
        this.retryCapacity = (CapacityManager)Validate.paramNotNull((Object)builder.retryCapacity, (String)"CapacityManager");
        this.sdkHttpClient = builder.sdkHttpClient;
        this.sdkAsyncHttpClient = builder.sdkAsyncHttpClient;
        this.clientExecutionTimer = (ClientExecutionTimer)Validate.paramNotNull((Object)builder.clientExecutionTimer, (String)"ClientExecutionTimer");
        this.executorService = builder.executorService;
        this.calculateCrc32FromCompressedData = builder.calculateCrc32FromCompressedData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public LegacyClientConfiguration config() {
        return this.config;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public CapacityManager retryCapacity() {
        return this.retryCapacity;
    }

    public SdkHttpClient sdkHttpClient() {
        return this.sdkHttpClient;
    }

    public SdkAsyncHttpClient sdkAsyncHttpClient() {
        return this.sdkAsyncHttpClient;
    }

    public ClientExecutionTimer clientExecutionTimer() {
        return this.clientExecutionTimer;
    }

    public ScheduledExecutorService executorService() {
        return this.executorService;
    }

    public boolean calculateCrc32FromCompressedData() {
        return this.calculateCrc32FromCompressedData;
    }

    public int timeOffset() {
        return this.timeOffset;
    }

    public void updateTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
        SdkGlobalTime.setGlobalTimeOffset(timeOffset);
    }

    @Override
    public void close() throws Exception {
        this.clientExecutionTimer.close();
        if (this.sdkAsyncHttpClient != null) {
            this.sdkAsyncHttpClient.close();
        }
        if (this.sdkHttpClient != null) {
            this.sdkHttpClient.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public static final class Builder {
        private LegacyClientConfiguration config;
        private RetryPolicy retryPolicy;
        private CapacityManager retryCapacity;
        private SdkHttpClient sdkHttpClient;
        private SdkAsyncHttpClient sdkAsyncHttpClient;
        private ClientExecutionTimer clientExecutionTimer;
        private ScheduledExecutorService executorService;
        private boolean calculateCrc32FromCompressedData;

        public Builder config(LegacyClientConfiguration config) {
            this.config = config;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder retryCapacity(CapacityManager retryCapacity) {
            this.retryCapacity = retryCapacity;
            return this;
        }

        public Builder sdkHttpClient(SdkHttpClient sdkHttpClient) {
            this.sdkHttpClient = sdkHttpClient;
            return this;
        }

        public Builder sdkAsyncHttpClient(SdkAsyncHttpClient sdkAsyncHttpClient) {
            this.sdkAsyncHttpClient = sdkAsyncHttpClient;
            return this;
        }

        public Builder clientExecutionTimer(ClientExecutionTimer clientExecutionTimer) {
            this.clientExecutionTimer = clientExecutionTimer;
            return this;
        }

        public Builder asyncExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder calculateCrc32FromCompressedData(boolean calculateCrc32FromCompressedData) {
            this.calculateCrc32FromCompressedData = calculateCrc32FromCompressedData;
            return this;
        }

        public HttpClientDependencies build() {
            return new HttpClientDependencies(this);
        }
    }
}

