/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.event.request;

import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.event.request.Progress;

@ThreadSafe
public class ProgressSupport
extends Progress {
    private static final Object LOCK = new Object();
    private volatile long requestContentLength = -1L;
    private volatile long requestBytesTransferred;
    private volatile long responseContentLength = -1L;
    private volatile long responseBytesTransferred;

    @Override
    public long getRequestContentLength() {
        return this.requestContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequestContentLength(long contentLength) {
        if (contentLength < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = LOCK;
        synchronized (object) {
            this.requestContentLength = this.requestContentLength == -1L ? contentLength : (this.requestContentLength += contentLength);
        }
    }

    @Override
    public long getRequestBytesTransferred() {
        return this.requestBytesTransferred;
    }

    @Override
    public long getResponseContentLength() {
        return this.responseContentLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResponseContentLength(long contentLength) {
        if (contentLength < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = LOCK;
        synchronized (object) {
            this.responseContentLength = this.responseContentLength == -1L ? contentLength : (this.responseContentLength += contentLength);
        }
    }

    @Override
    public long getResponseBytesTransferred() {
        return this.responseBytesTransferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequestBytesTransferred(long bytes) {
        Object object = LOCK;
        synchronized (object) {
            this.requestBytesTransferred += bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResponseBytesTransferred(long bytes) {
        Object object = LOCK;
        synchronized (object) {
            this.responseBytesTransferred += bytes;
        }
    }

    public String toString() {
        return String.format("Request: %d/%d, Response: %d/%d", this.requestBytesTransferred, this.requestContentLength, this.responseBytesTransferred, this.responseContentLength);
    }

    @Override
    public final boolean isEnabled() {
        return true;
    }
}

