/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.config;

import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import software.amazon.awssdk.LegacyClientConfiguration;
import software.amazon.awssdk.Protocol;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.config.AdvancedClientOption;
import software.amazon.awssdk.config.ClientConfiguration;
import software.amazon.awssdk.config.ClientOverrideConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public abstract class ImmutableClientConfiguration
implements ClientConfiguration {
    private final ClientOverrideConfiguration overrideConfiguration;
    private final AwsCredentialsProvider credentialsProvider;
    private final URI endpoint;
    private final LegacyClientConfiguration legacyConfiguration;

    public ImmutableClientConfiguration(ClientConfiguration configuration) {
        this.overrideConfiguration = configuration.overrideConfiguration();
        this.credentialsProvider = configuration.credentialsProvider();
        this.endpoint = configuration.endpoint();
        this.validate();
        this.legacyConfiguration = this.initializeLegacyConfiguration();
    }

    protected final <T> T requireField(String field, T requiredConfiguration) {
        return (T)Validate.notNull(requiredConfiguration, (String)"The '%s' must be configured in the client builder.", (Object[])new Object[]{field});
    }

    private void validate() {
        Validate.validState((this.endpoint() != null ? 1 : 0) != 0, (String)"The endpoint could not be determined.", (Object[])new Object[0]);
        this.requireField("overrideConfiguration.advancedOption[SIGNER_PROVIDER]", this.overrideConfiguration().advancedOption(AdvancedClientOption.SIGNER_PROVIDER));
        this.requireField("overrideConfiguration.gzipEnabled", this.overrideConfiguration().gzipEnabled());
        this.requireField("overrideConfiguration.requestMetricCollector", this.overrideConfiguration().requestMetricCollector());
        this.requireField("overrideConfiguration.advancedOption[USER_AGENT_PREFIX]", this.overrideConfiguration().advancedOption(AdvancedClientOption.USER_AGENT_PREFIX));
        this.requireField("overrideConfiguration.advancedOption[USER_AGENT_SUFFIX]", this.overrideConfiguration().advancedOption(AdvancedClientOption.USER_AGENT_SUFFIX));
        this.requireField("overrideConfiguration.retryPolicy", this.overrideConfiguration().retryPolicy());
        this.requireField("credentialsProvider", this.credentialsProvider());
        this.requireField("endpoint", this.endpoint());
    }

    @Override
    public ClientOverrideConfiguration overrideConfiguration() {
        return this.overrideConfiguration;
    }

    @Override
    public AwsCredentialsProvider credentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public URI endpoint() {
        return this.endpoint;
    }

    @Deprecated
    @ReviewBeforeRelease(value="This should be removed once we remove our reliance on the legacy client configuration object.")
    public LegacyClientConfiguration asLegacyConfiguration() {
        return this.legacyConfiguration;
    }

    private LegacyClientConfiguration initializeLegacyConfiguration() {
        LegacyClientConfiguration configuration = new LegacyClientConfiguration();
        this.copyOverrideConfiguration(configuration, this.overrideConfiguration());
        configuration.setProtocol(this.schemeToProtocol(this.endpoint().getScheme()).orElse(Protocol.HTTPS));
        return configuration;
    }

    private void copyOverrideConfiguration(LegacyClientConfiguration configuration, ClientOverrideConfiguration overrideConfiguration) {
        Optional.ofNullable(overrideConfiguration.totalExecutionTimeout()).ifPresent(d -> configuration.setClientExecutionTimeout(Math.toIntExact(d.toMillis())));
        Optional.ofNullable(overrideConfiguration.gzipEnabled()).ifPresent(configuration::setUseGzip);
        overrideConfiguration.additionalHttpHeaders().forEach((header, values) -> {
            if (values.size() > 1) {
                throw new IllegalArgumentException("Multiple values under the same header are not supported at this time.");
            }
            values.forEach(value -> configuration.addHeader((String)header, (String)value));
        });
        Optional.ofNullable(overrideConfiguration.advancedOption(AdvancedClientOption.USER_AGENT_PREFIX)).ifPresent(configuration::setUserAgentPrefix);
        Optional.ofNullable(overrideConfiguration.advancedOption(AdvancedClientOption.USER_AGENT_SUFFIX)).ifPresent(configuration::setUserAgentSuffix);
        Optional.ofNullable(overrideConfiguration.retryPolicy()).ifPresent(configuration::setRetryPolicy);
    }

    private Optional<Protocol> schemeToProtocol(String scheme) {
        return Arrays.stream(Protocol.values()).filter(p -> scheme.equals(p.toString())).findFirst();
    }
}

