/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.client;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.ThreadSafe;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AsyncClientHandlerImpl;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.internal.AmazonWebServiceRequestAdapter;
import software.amazon.awssdk.internal.http.response.AwsErrorResponseHandler;
import software.amazon.awssdk.metrics.spi.AwsRequestMetrics;

@ThreadSafe
@Immutable
public class SdkAsyncClientHandler
extends AsyncClientHandler {
    private final AsyncClientHandler delegateHandler;

    public SdkAsyncClientHandler(ClientHandlerParams handlerParams) {
        this.delegateHandler = new AsyncClientHandlerImpl(handlerParams);
    }

    @Override
    public <InputT, OutputT> CompletableFuture<OutputT> execute(ClientExecutionParams<InputT, OutputT> executionParams) {
        return this.delegateHandler.execute(this.addRequestConfig(executionParams).withErrorResponseHandler(new AwsErrorResponseHandler(executionParams.getErrorResponseHandler(), new AwsRequestMetrics())));
    }

    @Override
    public void close() throws Exception {
        this.delegateHandler.close();
    }

    private <InputT, OutputT> ClientExecutionParams<InputT, OutputT> addRequestConfig(ClientExecutionParams<InputT, OutputT> params) {
        return params.withRequestConfig(new AmazonWebServiceRequestAdapter((AmazonWebServiceRequest)params.getInput()));
    }
}

