/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkProtectedApi;

@SdkProtectedApi
public interface SdkClock {
    public static final SdkClock STANDARD = new SdkClock(){

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    };

    public long currentTimeMillis();

    public static final class MockClock
    implements SdkClock {
        private final long mockedTime;

        public MockClock(Date mockedTime) {
            this(mockedTime.getTime());
        }

        public MockClock(long mockedTime) {
            this.mockedTime = mockedTime;
        }

        @Override
        public long currentTimeMillis() {
            return this.mockedTime;
        }
    }
}

