/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.ControlOperationSummary;
import software.amazon.awssdk.services.controltower.model.ListControlOperationsRequest;
import software.amazon.awssdk.services.controltower.model.ListControlOperationsResponse;

public class ListControlOperationsIterable
implements SdkIterable<ListControlOperationsResponse> {
    private final ControlTowerClient client;
    private final ListControlOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListControlOperationsIterable(ControlTowerClient client, ListControlOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListControlOperationsResponseFetcher();
    }

    public Iterator<ListControlOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ControlOperationSummary> controlOperations() {
        Function<ListControlOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controlOperations() != null) {
                return response.controlOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListControlOperationsResponseFetcher
    implements SyncPageFetcher<ListControlOperationsResponse> {
        private ListControlOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListControlOperationsResponse nextPage(ListControlOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListControlOperationsIterable.this.client.listControlOperations(ListControlOperationsIterable.this.firstRequest);
            }
            return ListControlOperationsIterable.this.client.listControlOperations((ListControlOperationsRequest)((Object)ListControlOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

