/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controlcatalog.model.CommonControlArnFilterListCopier;
import software.amazon.awssdk.services.controlcatalog.model.ControlArnFilterListCopier;
import software.amazon.awssdk.services.controlcatalog.model.MappingType;
import software.amazon.awssdk.services.controlcatalog.model.MappingTypeFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlMappingFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlMappingFilter> {
    private static final SdkField<List<String>> CONTROL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ControlArns").getter(ControlMappingFilter.getter(ControlMappingFilter::controlArns)).setter(ControlMappingFilter.setter(Builder::controlArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMMON_CONTROL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CommonControlArns").getter(ControlMappingFilter.getter(ControlMappingFilter::commonControlArns)).setter(ControlMappingFilter.setter(Builder::commonControlArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonControlArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MAPPING_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MappingTypes").getter(ControlMappingFilter.getter(ControlMappingFilter::mappingTypesAsStrings)).setter(ControlMappingFilter.setter(Builder::mappingTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MappingTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ARNS_FIELD, COMMON_CONTROL_ARNS_FIELD, MAPPING_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ControlMappingFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> controlArns;
    private final List<String> commonControlArns;
    private final List<String> mappingTypes;

    private ControlMappingFilter(BuilderImpl builder) {
        this.controlArns = builder.controlArns;
        this.commonControlArns = builder.commonControlArns;
        this.mappingTypes = builder.mappingTypes;
    }

    public final boolean hasControlArns() {
        return this.controlArns != null && !(this.controlArns instanceof SdkAutoConstructList);
    }

    public final List<String> controlArns() {
        return this.controlArns;
    }

    public final boolean hasCommonControlArns() {
        return this.commonControlArns != null && !(this.commonControlArns instanceof SdkAutoConstructList);
    }

    public final List<String> commonControlArns() {
        return this.commonControlArns;
    }

    public final List<MappingType> mappingTypes() {
        return MappingTypeFilterListCopier.copyStringToEnum(this.mappingTypes);
    }

    public final boolean hasMappingTypes() {
        return this.mappingTypes != null && !(this.mappingTypes instanceof SdkAutoConstructList);
    }

    public final List<String> mappingTypesAsStrings() {
        return this.mappingTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlArns() ? this.controlArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommonControlArns() ? this.commonControlArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMappingTypes() ? this.mappingTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlMappingFilter)) {
            return false;
        }
        ControlMappingFilter other = (ControlMappingFilter)obj;
        return this.hasControlArns() == other.hasControlArns() && Objects.equals(this.controlArns(), other.controlArns()) && this.hasCommonControlArns() == other.hasCommonControlArns() && Objects.equals(this.commonControlArns(), other.commonControlArns()) && this.hasMappingTypes() == other.hasMappingTypes() && Objects.equals(this.mappingTypesAsStrings(), other.mappingTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ControlMappingFilter").add("ControlArns", this.hasControlArns() ? this.controlArns() : null).add("CommonControlArns", this.hasCommonControlArns() ? this.commonControlArns() : null).add("MappingTypes", this.hasMappingTypes() ? this.mappingTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlArns": {
                return Optional.ofNullable(clazz.cast(this.controlArns()));
            }
            case "CommonControlArns": {
                return Optional.ofNullable(clazz.cast(this.commonControlArns()));
            }
            case "MappingTypes": {
                return Optional.ofNullable(clazz.cast(this.mappingTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ControlArns", CONTROL_ARNS_FIELD);
        map.put("CommonControlArns", COMMON_CONTROL_ARNS_FIELD);
        map.put("MappingTypes", MAPPING_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlMappingFilter, T> g) {
        return obj -> g.apply((ControlMappingFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> controlArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> commonControlArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> mappingTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ControlMappingFilter model) {
            this.controlArns(model.controlArns);
            this.commonControlArns(model.commonControlArns);
            this.mappingTypesWithStrings(model.mappingTypes);
        }

        public final Collection<String> getControlArns() {
            if (this.controlArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.controlArns;
        }

        public final void setControlArns(Collection<String> controlArns) {
            this.controlArns = ControlArnFilterListCopier.copy(controlArns);
        }

        @Override
        public final Builder controlArns(Collection<String> controlArns) {
            this.controlArns = ControlArnFilterListCopier.copy(controlArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlArns(String ... controlArns) {
            this.controlArns(Arrays.asList(controlArns));
            return this;
        }

        public final Collection<String> getCommonControlArns() {
            if (this.commonControlArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.commonControlArns;
        }

        public final void setCommonControlArns(Collection<String> commonControlArns) {
            this.commonControlArns = CommonControlArnFilterListCopier.copy(commonControlArns);
        }

        @Override
        public final Builder commonControlArns(Collection<String> commonControlArns) {
            this.commonControlArns = CommonControlArnFilterListCopier.copy(commonControlArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonControlArns(String ... commonControlArns) {
            this.commonControlArns(Arrays.asList(commonControlArns));
            return this;
        }

        public final Collection<String> getMappingTypes() {
            if (this.mappingTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mappingTypes;
        }

        public final void setMappingTypes(Collection<String> mappingTypes) {
            this.mappingTypes = MappingTypeFilterListCopier.copy(mappingTypes);
        }

        @Override
        public final Builder mappingTypesWithStrings(Collection<String> mappingTypes) {
            this.mappingTypes = MappingTypeFilterListCopier.copy(mappingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappingTypesWithStrings(String ... mappingTypes) {
            this.mappingTypesWithStrings(Arrays.asList(mappingTypes));
            return this;
        }

        @Override
        public final Builder mappingTypes(Collection<MappingType> mappingTypes) {
            this.mappingTypes = MappingTypeFilterListCopier.copyEnumToString(mappingTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappingTypes(MappingType ... mappingTypes) {
            this.mappingTypes(Arrays.asList(mappingTypes));
            return this;
        }

        public ControlMappingFilter build() {
            return new ControlMappingFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlMappingFilter> {
        public Builder controlArns(Collection<String> var1);

        public Builder controlArns(String ... var1);

        public Builder commonControlArns(Collection<String> var1);

        public Builder commonControlArns(String ... var1);

        public Builder mappingTypesWithStrings(Collection<String> var1);

        public Builder mappingTypesWithStrings(String ... var1);

        public Builder mappingTypes(Collection<MappingType> var1);

        public Builder mappingTypes(MappingType ... var1);
    }
}

