/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogClient;
import software.amazon.awssdk.services.controlcatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.controlcatalog.model.CommonControlSummary;
import software.amazon.awssdk.services.controlcatalog.model.ListCommonControlsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListCommonControlsResponse;

public class ListCommonControlsIterable
implements SdkIterable<ListCommonControlsResponse> {
    private final ControlCatalogClient client;
    private final ListCommonControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommonControlsIterable(ControlCatalogClient client, ListCommonControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCommonControlsResponseFetcher();
    }

    public Iterator<ListCommonControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CommonControlSummary> commonControls() {
        Function<ListCommonControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commonControls() != null) {
                return response.commonControls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCommonControlsResponseFetcher
    implements SyncPageFetcher<ListCommonControlsResponse> {
        private ListCommonControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommonControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCommonControlsResponse nextPage(ListCommonControlsResponse previousPage) {
            if (previousPage == null) {
                return ListCommonControlsIterable.this.client.listCommonControls(ListCommonControlsIterable.this.firstRequest);
            }
            return ListCommonControlsIterable.this.client.listCommonControls((ListCommonControlsRequest)((Object)ListCommonControlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

