/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ControlBehavior {
    PREVENTIVE("PREVENTIVE"),
    PROACTIVE("PROACTIVE"),
    DETECTIVE("DETECTIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ControlBehavior> VALUE_MAP;
    private final String value;

    private ControlBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlBehavior> knownValues() {
        EnumSet<ControlBehavior> knownValues = EnumSet.allOf(ControlBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ControlBehavior.class, ControlBehavior::toString);
    }
}

