/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates the participant’s WebRTC connection data required for the client application (mobile or web) to connect to
 * the call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebRTCConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<WebRTCConnection.Builder, WebRTCConnection> {
    private static final SdkField<Attendee> ATTENDEE_FIELD = SdkField.<Attendee> builder(MarshallingType.SDK_POJO)
            .memberName("Attendee").getter(getter(WebRTCConnection::attendee)).setter(setter(Builder::attendee))
            .constructor(Attendee::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attendee").build()).build();

    private static final SdkField<WebRTCMeeting> MEETING_FIELD = SdkField.<WebRTCMeeting> builder(MarshallingType.SDK_POJO)
            .memberName("Meeting").getter(getter(WebRTCConnection::meeting)).setter(setter(Builder::meeting))
            .constructor(WebRTCMeeting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Meeting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ATTENDEE_FIELD, MEETING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Attendee attendee;

    private final WebRTCMeeting meeting;

    private WebRTCConnection(BuilderImpl builder) {
        this.attendee = builder.attendee;
        this.meeting = builder.meeting;
    }

    /**
     * Returns the value of the Attendee property for this object.
     * 
     * @return The value of the Attendee property for this object.
     */
    public final Attendee attendee() {
        return attendee;
    }

    /**
     * <p>
     * A meeting created using the Amazon Chime SDK.
     * </p>
     * 
     * @return A meeting created using the Amazon Chime SDK.
     */
    public final WebRTCMeeting meeting() {
        return meeting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attendee());
        hashCode = 31 * hashCode + Objects.hashCode(meeting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebRTCConnection)) {
            return false;
        }
        WebRTCConnection other = (WebRTCConnection) obj;
        return Objects.equals(attendee(), other.attendee()) && Objects.equals(meeting(), other.meeting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebRTCConnection").add("Attendee", attendee()).add("Meeting", meeting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attendee":
            return Optional.ofNullable(clazz.cast(attendee()));
        case "Meeting":
            return Optional.ofNullable(clazz.cast(meeting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attendee", ATTENDEE_FIELD);
        map.put("Meeting", MEETING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebRTCConnection, T> g) {
        return obj -> g.apply((WebRTCConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebRTCConnection> {
        /**
         * Sets the value of the Attendee property for this object.
         *
         * @param attendee
         *        The new value for the Attendee property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attendee(Attendee attendee);

        /**
         * Sets the value of the Attendee property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Attendee.Builder} avoiding the need to
         * create one manually via {@link Attendee#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Attendee.Builder#build()} is called immediately and its result is
         * passed to {@link #attendee(Attendee)}.
         * 
         * @param attendee
         *        a consumer that will call methods on {@link Attendee.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attendee(Attendee)
         */
        default Builder attendee(Consumer<Attendee.Builder> attendee) {
            return attendee(Attendee.builder().applyMutation(attendee).build());
        }

        /**
         * <p>
         * A meeting created using the Amazon Chime SDK.
         * </p>
         * 
         * @param meeting
         *        A meeting created using the Amazon Chime SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meeting(WebRTCMeeting meeting);

        /**
         * <p>
         * A meeting created using the Amazon Chime SDK.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebRTCMeeting.Builder} avoiding the need
         * to create one manually via {@link WebRTCMeeting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebRTCMeeting.Builder#build()} is called immediately and its
         * result is passed to {@link #meeting(WebRTCMeeting)}.
         * 
         * @param meeting
         *        a consumer that will call methods on {@link WebRTCMeeting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #meeting(WebRTCMeeting)
         */
        default Builder meeting(Consumer<WebRTCMeeting.Builder> meeting) {
            return meeting(WebRTCMeeting.builder().applyMutation(meeting).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Attendee attendee;

        private WebRTCMeeting meeting;

        private BuilderImpl() {
        }

        private BuilderImpl(WebRTCConnection model) {
            attendee(model.attendee);
            meeting(model.meeting);
        }

        public final Attendee.Builder getAttendee() {
            return attendee != null ? attendee.toBuilder() : null;
        }

        public final void setAttendee(Attendee.BuilderImpl attendee) {
            this.attendee = attendee != null ? attendee.build() : null;
        }

        @Override
        public final Builder attendee(Attendee attendee) {
            this.attendee = attendee;
            return this;
        }

        public final WebRTCMeeting.Builder getMeeting() {
            return meeting != null ? meeting.toBuilder() : null;
        }

        public final void setMeeting(WebRTCMeeting.BuilderImpl meeting) {
            this.meeting = meeting != null ? meeting.build() : null;
        }

        @Override
        public final Builder meeting(WebRTCMeeting meeting) {
            this.meeting = meeting;
            return this;
        }

        @Override
        public WebRTCConnection build() {
            return new WebRTCConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
