/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The receipt for the message delivered to the recipient.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Receipt implements SdkPojo, Serializable, ToCopyableBuilder<Receipt.Builder, Receipt> {
    private static final SdkField<String> DELIVERED_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveredTimestamp").getter(getter(Receipt::deliveredTimestamp))
            .setter(setter(Builder::deliveredTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveredTimestamp").build())
            .build();

    private static final SdkField<String> READ_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReadTimestamp").getter(getter(Receipt::readTimestamp)).setter(setter(Builder::readTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadTimestamp").build()).build();

    private static final SdkField<String> RECIPIENT_PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipientParticipantId").getter(getter(Receipt::recipientParticipantId))
            .setter(setter(Builder::recipientParticipantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipientParticipantId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERED_TIMESTAMP_FIELD,
            READ_TIMESTAMP_FIELD, RECIPIENT_PARTICIPANT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deliveredTimestamp;

    private final String readTimestamp;

    private final String recipientParticipantId;

    private Receipt(BuilderImpl builder) {
        this.deliveredTimestamp = builder.deliveredTimestamp;
        this.readTimestamp = builder.readTimestamp;
        this.recipientParticipantId = builder.recipientParticipantId;
    }

    /**
     * <p>
     * The time when the message was delivered to the recipient.
     * </p>
     * 
     * @return The time when the message was delivered to the recipient.
     */
    public final String deliveredTimestamp() {
        return deliveredTimestamp;
    }

    /**
     * <p>
     * The time when the message was read by the recipient.
     * </p>
     * 
     * @return The time when the message was read by the recipient.
     */
    public final String readTimestamp() {
        return readTimestamp;
    }

    /**
     * <p>
     * The identifier of the recipient of the message.
     * </p>
     * 
     * @return The identifier of the recipient of the message.
     */
    public final String recipientParticipantId() {
        return recipientParticipantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveredTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(readTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(recipientParticipantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Receipt)) {
            return false;
        }
        Receipt other = (Receipt) obj;
        return Objects.equals(deliveredTimestamp(), other.deliveredTimestamp())
                && Objects.equals(readTimestamp(), other.readTimestamp())
                && Objects.equals(recipientParticipantId(), other.recipientParticipantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Receipt").add("DeliveredTimestamp", deliveredTimestamp()).add("ReadTimestamp", readTimestamp())
                .add("RecipientParticipantId", recipientParticipantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveredTimestamp":
            return Optional.ofNullable(clazz.cast(deliveredTimestamp()));
        case "ReadTimestamp":
            return Optional.ofNullable(clazz.cast(readTimestamp()));
        case "RecipientParticipantId":
            return Optional.ofNullable(clazz.cast(recipientParticipantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveredTimestamp", DELIVERED_TIMESTAMP_FIELD);
        map.put("ReadTimestamp", READ_TIMESTAMP_FIELD);
        map.put("RecipientParticipantId", RECIPIENT_PARTICIPANT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Receipt, T> g) {
        return obj -> g.apply((Receipt) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Receipt> {
        /**
         * <p>
         * The time when the message was delivered to the recipient.
         * </p>
         * 
         * @param deliveredTimestamp
         *        The time when the message was delivered to the recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveredTimestamp(String deliveredTimestamp);

        /**
         * <p>
         * The time when the message was read by the recipient.
         * </p>
         * 
         * @param readTimestamp
         *        The time when the message was read by the recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readTimestamp(String readTimestamp);

        /**
         * <p>
         * The identifier of the recipient of the message.
         * </p>
         * 
         * @param recipientParticipantId
         *        The identifier of the recipient of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipientParticipantId(String recipientParticipantId);
    }

    static final class BuilderImpl implements Builder {
        private String deliveredTimestamp;

        private String readTimestamp;

        private String recipientParticipantId;

        private BuilderImpl() {
        }

        private BuilderImpl(Receipt model) {
            deliveredTimestamp(model.deliveredTimestamp);
            readTimestamp(model.readTimestamp);
            recipientParticipantId(model.recipientParticipantId);
        }

        public final String getDeliveredTimestamp() {
            return deliveredTimestamp;
        }

        public final void setDeliveredTimestamp(String deliveredTimestamp) {
            this.deliveredTimestamp = deliveredTimestamp;
        }

        @Override
        public final Builder deliveredTimestamp(String deliveredTimestamp) {
            this.deliveredTimestamp = deliveredTimestamp;
            return this;
        }

        public final String getReadTimestamp() {
            return readTimestamp;
        }

        public final void setReadTimestamp(String readTimestamp) {
            this.readTimestamp = readTimestamp;
        }

        @Override
        public final Builder readTimestamp(String readTimestamp) {
            this.readTimestamp = readTimestamp;
            return this;
        }

        public final String getRecipientParticipantId() {
            return recipientParticipantId;
        }

        public final void setRecipientParticipantId(String recipientParticipantId) {
            this.recipientParticipantId = recipientParticipantId;
        }

        @Override
        public final Builder recipientParticipantId(String recipientParticipantId) {
            this.recipientParticipantId = recipientParticipantId;
            return this;
        }

        @Override
        public Receipt build() {
            return new Receipt(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
