/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAttachmentRequest extends ConnectParticipantRequest implements
        ToCopyableBuilder<GetAttachmentRequest.Builder, GetAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachmentId").getter(getter(GetAttachmentRequest::attachmentId)).setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentId").build()).build();

    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionToken").getter(getter(GetAttachmentRequest::connectionToken))
            .setter(setter(Builder::connectionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()).build();

    private static final SdkField<Integer> URL_EXPIRY_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UrlExpiryInSeconds").getter(getter(GetAttachmentRequest::urlExpiryInSeconds))
            .setter(setter(Builder::urlExpiryInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlExpiryInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            CONNECTION_TOKEN_FIELD, URL_EXPIRY_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String attachmentId;

    private final String connectionToken;

    private final Integer urlExpiryInSeconds;

    private GetAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.connectionToken = builder.connectionToken;
        this.urlExpiryInSeconds = builder.urlExpiryInSeconds;
    }

    /**
     * <p>
     * A unique identifier for the attachment.
     * </p>
     * 
     * @return A unique identifier for the attachment.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The authentication token associated with the participant's connection.
     * </p>
     * 
     * @return The authentication token associated with the participant's connection.
     */
    public final String connectionToken() {
        return connectionToken;
    }

    /**
     * <p>
     * The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For
     * example, 2019-11-08T02:41:28.172Z.
     * </p>
     * 
     * @return The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format:
     *         yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
     */
    public final Integer urlExpiryInSeconds() {
        return urlExpiryInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionToken());
        hashCode = 31 * hashCode + Objects.hashCode(urlExpiryInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAttachmentRequest)) {
            return false;
        }
        GetAttachmentRequest other = (GetAttachmentRequest) obj;
        return Objects.equals(attachmentId(), other.attachmentId()) && Objects.equals(connectionToken(), other.connectionToken())
                && Objects.equals(urlExpiryInSeconds(), other.urlExpiryInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAttachmentRequest").add("AttachmentId", attachmentId())
                .add("ConnectionToken", connectionToken()).add("UrlExpiryInSeconds", urlExpiryInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "ConnectionToken":
            return Optional.ofNullable(clazz.cast(connectionToken()));
        case "UrlExpiryInSeconds":
            return Optional.ofNullable(clazz.cast(urlExpiryInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachmentId", ATTACHMENT_ID_FIELD);
        map.put("X-Amz-Bearer", CONNECTION_TOKEN_FIELD);
        map.put("UrlExpiryInSeconds", URL_EXPIRY_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAttachmentRequest, T> g) {
        return obj -> g.apply((GetAttachmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectParticipantRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAttachmentRequest> {
        /**
         * <p>
         * A unique identifier for the attachment.
         * </p>
         * 
         * @param attachmentId
         *        A unique identifier for the attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The authentication token associated with the participant's connection.
         * </p>
         * 
         * @param connectionToken
         *        The authentication token associated with the participant's connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionToken(String connectionToken);

        /**
         * <p>
         * The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ.
         * For example, 2019-11-08T02:41:28.172Z.
         * </p>
         * 
         * @param urlExpiryInSeconds
         *        The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format:
         *        yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlExpiryInSeconds(Integer urlExpiryInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectParticipantRequest.BuilderImpl implements Builder {
        private String attachmentId;

        private String connectionToken;

        private Integer urlExpiryInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAttachmentRequest model) {
            super(model);
            attachmentId(model.attachmentId);
            connectionToken(model.connectionToken);
            urlExpiryInSeconds(model.urlExpiryInSeconds);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getConnectionToken() {
            return connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        public final Integer getUrlExpiryInSeconds() {
            return urlExpiryInSeconds;
        }

        public final void setUrlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
        }

        @Override
        public final Builder urlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAttachmentRequest build() {
            return new GetAttachmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
