/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Receipt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Receipt> {
    private static final SdkField<String> DELIVERED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveredTimestamp").getter(Receipt.getter(Receipt::deliveredTimestamp)).setter(Receipt.setter(Builder::deliveredTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveredTimestamp").build()}).build();
    private static final SdkField<String> READ_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadTimestamp").getter(Receipt.getter(Receipt::readTimestamp)).setter(Receipt.setter(Builder::readTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadTimestamp").build()}).build();
    private static final SdkField<String> RECIPIENT_PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecipientParticipantId").getter(Receipt.getter(Receipt::recipientParticipantId)).setter(Receipt.setter(Builder::recipientParticipantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipientParticipantId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERED_TIMESTAMP_FIELD, READ_TIMESTAMP_FIELD, RECIPIENT_PARTICIPANT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deliveredTimestamp;
    private final String readTimestamp;
    private final String recipientParticipantId;

    private Receipt(BuilderImpl builder) {
        this.deliveredTimestamp = builder.deliveredTimestamp;
        this.readTimestamp = builder.readTimestamp;
        this.recipientParticipantId = builder.recipientParticipantId;
    }

    public final String deliveredTimestamp() {
        return this.deliveredTimestamp;
    }

    public final String readTimestamp() {
        return this.readTimestamp;
    }

    public final String recipientParticipantId() {
        return this.recipientParticipantId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveredTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.readTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipientParticipantId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Receipt)) {
            return false;
        }
        Receipt other = (Receipt)obj;
        return Objects.equals(this.deliveredTimestamp(), other.deliveredTimestamp()) && Objects.equals(this.readTimestamp(), other.readTimestamp()) && Objects.equals(this.recipientParticipantId(), other.recipientParticipantId());
    }

    public final String toString() {
        return ToString.builder((String)"Receipt").add("DeliveredTimestamp", (Object)this.deliveredTimestamp()).add("ReadTimestamp", (Object)this.readTimestamp()).add("RecipientParticipantId", (Object)this.recipientParticipantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveredTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deliveredTimestamp()));
            }
            case "ReadTimestamp": {
                return Optional.ofNullable(clazz.cast(this.readTimestamp()));
            }
            case "RecipientParticipantId": {
                return Optional.ofNullable(clazz.cast(this.recipientParticipantId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Receipt, T> g) {
        return obj -> g.apply((Receipt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deliveredTimestamp;
        private String readTimestamp;
        private String recipientParticipantId;

        private BuilderImpl() {
        }

        private BuilderImpl(Receipt model) {
            this.deliveredTimestamp(model.deliveredTimestamp);
            this.readTimestamp(model.readTimestamp);
            this.recipientParticipantId(model.recipientParticipantId);
        }

        public final String getDeliveredTimestamp() {
            return this.deliveredTimestamp;
        }

        public final void setDeliveredTimestamp(String deliveredTimestamp) {
            this.deliveredTimestamp = deliveredTimestamp;
        }

        @Override
        public final Builder deliveredTimestamp(String deliveredTimestamp) {
            this.deliveredTimestamp = deliveredTimestamp;
            return this;
        }

        public final String getReadTimestamp() {
            return this.readTimestamp;
        }

        public final void setReadTimestamp(String readTimestamp) {
            this.readTimestamp = readTimestamp;
        }

        @Override
        public final Builder readTimestamp(String readTimestamp) {
            this.readTimestamp = readTimestamp;
            return this;
        }

        public final String getRecipientParticipantId() {
            return this.recipientParticipantId;
        }

        public final void setRecipientParticipantId(String recipientParticipantId) {
            this.recipientParticipantId = recipientParticipantId;
        }

        @Override
        public final Builder recipientParticipantId(String recipientParticipantId) {
            this.recipientParticipantId = recipientParticipantId;
            return this;
        }

        public Receipt build() {
            return new Receipt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Receipt> {
        public Builder deliveredTimestamp(String var1);

        public Builder readTimestamp(String var1);

        public Builder recipientParticipantId(String var1);
    }
}

