/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of items that represent RelatedItems.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRelatedItemsResponseItem implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchRelatedItemsResponseItem.Builder, SearchRelatedItemsResponseItem> {
    private static final SdkField<String> RELATED_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relatedItemId").getter(getter(SearchRelatedItemsResponseItem::relatedItemId))
            .setter(setter(Builder::relatedItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SearchRelatedItemsResponseItem::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> ASSOCIATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("associationTime")
            .getter(getter(SearchRelatedItemsResponseItem::associationTime))
            .setter(setter(Builder::associationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<RelatedItemContent> CONTENT_FIELD = SdkField
            .<RelatedItemContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(SearchRelatedItemsResponseItem::content)).setter(setter(Builder::content))
            .constructor(RelatedItemContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SearchRelatedItemsResponseItem::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<UserUnion> PERFORMED_BY_FIELD = SdkField.<UserUnion> builder(MarshallingType.SDK_POJO)
            .memberName("performedBy").getter(getter(SearchRelatedItemsResponseItem::performedBy))
            .setter(setter(Builder::performedBy)).constructor(UserUnion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATED_ITEM_ID_FIELD,
            TYPE_FIELD, ASSOCIATION_TIME_FIELD, CONTENT_FIELD, TAGS_FIELD, PERFORMED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String relatedItemId;

    private final String type;

    private final Instant associationTime;

    private final RelatedItemContent content;

    private final Map<String, String> tags;

    private final UserUnion performedBy;

    private SearchRelatedItemsResponseItem(BuilderImpl builder) {
        this.relatedItemId = builder.relatedItemId;
        this.type = builder.type;
        this.associationTime = builder.associationTime;
        this.content = builder.content;
        this.tags = builder.tags;
        this.performedBy = builder.performedBy;
    }

    /**
     * <p>
     * Unique identifier of a related item.
     * </p>
     * 
     * @return Unique identifier of a related item.
     */
    public final String relatedItemId() {
        return relatedItemId;
    }

    /**
     * <p>
     * Type of a related item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RelatedItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of a related item.
     * @see RelatedItemType
     */
    public final RelatedItemType type() {
        return RelatedItemType.fromValue(type);
    }

    /**
     * <p>
     * Type of a related item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RelatedItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of a related item.
     * @see RelatedItemType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Time at which a related item was associated with a case.
     * </p>
     * 
     * @return Time at which a related item was associated with a case.
     */
    public final Instant associationTime() {
        return associationTime;
    }

    /**
     * <p>
     * Represents the content of a particular type of related item.
     * </p>
     * 
     * @return Represents the content of a particular type of related item.
     */
    public final RelatedItemContent content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
     * access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
     *         control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Represents the creator of the related item.
     * </p>
     * 
     * @return Represents the creator of the related item.
     */
    public final UserUnion performedBy() {
        return performedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relatedItemId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associationTime());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(performedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRelatedItemsResponseItem)) {
            return false;
        }
        SearchRelatedItemsResponseItem other = (SearchRelatedItemsResponseItem) obj;
        return Objects.equals(relatedItemId(), other.relatedItemId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(associationTime(), other.associationTime()) && Objects.equals(content(), other.content())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(performedBy(), other.performedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchRelatedItemsResponseItem").add("RelatedItemId", relatedItemId())
                .add("Type", typeAsString()).add("AssociationTime", associationTime()).add("Content", content())
                .add("Tags", hasTags() ? tags() : null).add("PerformedBy", performedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relatedItemId":
            return Optional.ofNullable(clazz.cast(relatedItemId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "associationTime":
            return Optional.ofNullable(clazz.cast(associationTime()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "performedBy":
            return Optional.ofNullable(clazz.cast(performedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relatedItemId", RELATED_ITEM_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("associationTime", ASSOCIATION_TIME_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("performedBy", PERFORMED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchRelatedItemsResponseItem, T> g) {
        return obj -> g.apply((SearchRelatedItemsResponseItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchRelatedItemsResponseItem> {
        /**
         * <p>
         * Unique identifier of a related item.
         * </p>
         * 
         * @param relatedItemId
         *        Unique identifier of a related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedItemId(String relatedItemId);

        /**
         * <p>
         * Type of a related item.
         * </p>
         * 
         * @param type
         *        Type of a related item.
         * @see RelatedItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedItemType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of a related item.
         * </p>
         * 
         * @param type
         *        Type of a related item.
         * @see RelatedItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelatedItemType
         */
        Builder type(RelatedItemType type);

        /**
         * <p>
         * Time at which a related item was associated with a case.
         * </p>
         * 
         * @param associationTime
         *        Time at which a related item was associated with a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTime(Instant associationTime);

        /**
         * <p>
         * Represents the content of a particular type of related item.
         * </p>
         * 
         * @param content
         *        Represents the content of a particular type of related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(RelatedItemContent content);

        /**
         * <p>
         * Represents the content of a particular type of related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedItemContent.Builder} avoiding the
         * need to create one manually via {@link RelatedItemContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedItemContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(RelatedItemContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link RelatedItemContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(RelatedItemContent)
         */
        default Builder content(Consumer<RelatedItemContent.Builder> content) {
            return content(RelatedItemContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
         * access for this resource.
         * </p>
         * 
         * @param tags
         *        A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
         *        control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Represents the creator of the related item.
         * </p>
         * 
         * @param performedBy
         *        Represents the creator of the related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performedBy(UserUnion performedBy);

        /**
         * <p>
         * Represents the creator of the related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserUnion.Builder} avoiding the need to
         * create one manually via {@link UserUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserUnion.Builder#build()} is called immediately and its result
         * is passed to {@link #performedBy(UserUnion)}.
         * 
         * @param performedBy
         *        a consumer that will call methods on {@link UserUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performedBy(UserUnion)
         */
        default Builder performedBy(Consumer<UserUnion.Builder> performedBy) {
            return performedBy(UserUnion.builder().applyMutation(performedBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String relatedItemId;

        private String type;

        private Instant associationTime;

        private RelatedItemContent content;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private UserUnion performedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRelatedItemsResponseItem model) {
            relatedItemId(model.relatedItemId);
            type(model.type);
            associationTime(model.associationTime);
            content(model.content);
            tags(model.tags);
            performedBy(model.performedBy);
        }

        public final String getRelatedItemId() {
            return relatedItemId;
        }

        public final void setRelatedItemId(String relatedItemId) {
            this.relatedItemId = relatedItemId;
        }

        @Override
        public final Builder relatedItemId(String relatedItemId) {
            this.relatedItemId = relatedItemId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RelatedItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getAssociationTime() {
            return associationTime;
        }

        public final void setAssociationTime(Instant associationTime) {
            this.associationTime = associationTime;
        }

        @Override
        public final Builder associationTime(Instant associationTime) {
            this.associationTime = associationTime;
            return this;
        }

        public final RelatedItemContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(RelatedItemContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(RelatedItemContent content) {
            this.content = content;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final UserUnion.Builder getPerformedBy() {
            return performedBy != null ? performedBy.toBuilder() : null;
        }

        public final void setPerformedBy(UserUnion.BuilderImpl performedBy) {
            this.performedBy = performedBy != null ? performedBy.build() : null;
        }

        @Override
        public final Builder performedBy(UserUnion performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        @Override
        public SearchRelatedItemsResponseItem build() {
            return new SearchRelatedItemsResponseItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
