/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of types of related items and their parameters to use for filtering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedItemTypeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedItemTypeFilter.Builder, RelatedItemTypeFilter> {
    private static final SdkField<ContactFilter> CONTACT_FIELD = SdkField.<ContactFilter> builder(MarshallingType.SDK_POJO)
            .memberName("contact").getter(getter(RelatedItemTypeFilter::contact)).setter(setter(Builder::contact))
            .constructor(ContactFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contact").build()).build();

    private static final SdkField<CommentFilter> COMMENT_FIELD = SdkField.<CommentFilter> builder(MarshallingType.SDK_POJO)
            .memberName("comment").getter(getter(RelatedItemTypeFilter::comment)).setter(setter(Builder::comment))
            .constructor(CommentFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<FileFilter> FILE_FIELD = SdkField.<FileFilter> builder(MarshallingType.SDK_POJO)
            .memberName("file").getter(getter(RelatedItemTypeFilter::file)).setter(setter(Builder::file))
            .constructor(FileFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<SlaFilter> SLA_FIELD = SdkField.<SlaFilter> builder(MarshallingType.SDK_POJO).memberName("sla")
            .getter(getter(RelatedItemTypeFilter::sla)).setter(setter(Builder::sla)).constructor(SlaFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sla").build()).build();

    private static final SdkField<ConnectCaseFilter> CONNECT_CASE_FIELD = SdkField
            .<ConnectCaseFilter> builder(MarshallingType.SDK_POJO).memberName("connectCase")
            .getter(getter(RelatedItemTypeFilter::connectCase)).setter(setter(Builder::connectCase))
            .constructor(ConnectCaseFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCase").build()).build();

    private static final SdkField<CustomFilter> CUSTOM_FIELD = SdkField.<CustomFilter> builder(MarshallingType.SDK_POJO)
            .memberName("custom").getter(getter(RelatedItemTypeFilter::custom)).setter(setter(Builder::custom))
            .constructor(CustomFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FIELD, COMMENT_FIELD,
            FILE_FIELD, SLA_FIELD, CONNECT_CASE_FIELD, CUSTOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ContactFilter contact;

    private final CommentFilter comment;

    private final FileFilter file;

    private final SlaFilter sla;

    private final ConnectCaseFilter connectCase;

    private final CustomFilter custom;

    private final Type type;

    private RelatedItemTypeFilter(BuilderImpl builder) {
        this.contact = builder.contact;
        this.comment = builder.comment;
        this.file = builder.file;
        this.sla = builder.sla;
        this.connectCase = builder.connectCase;
        this.custom = builder.custom;
        this.type = builder.type;
    }

    /**
     * <p>
     * A filter for related items of type <code>Contact</code>.
     * </p>
     * 
     * @return A filter for related items of type <code>Contact</code>.
     */
    public final ContactFilter contact() {
        return contact;
    }

    /**
     * <p>
     * A filter for related items of type <code>Comment</code>.
     * </p>
     * 
     * @return A filter for related items of type <code>Comment</code>.
     */
    public final CommentFilter comment() {
        return comment;
    }

    /**
     * <p>
     * A filter for related items of this type of <code>File</code>.
     * </p>
     * 
     * @return A filter for related items of this type of <code>File</code>.
     */
    public final FileFilter file() {
        return file;
    }

    /**
     * <p>
     * Filter for related items of type <code>SLA</code>.
     * </p>
     * 
     * @return Filter for related items of type <code>SLA</code>.
     */
    public final SlaFilter sla() {
        return sla;
    }

    /**
     * <p>
     * Represents the Amazon Connect case to be created as a related item.
     * </p>
     * 
     * @return Represents the Amazon Connect case to be created as a related item.
     */
    public final ConnectCaseFilter connectCase() {
        return connectCase;
    }

    /**
     * <p>
     * Represents the content of a <code>Custom</code> type related item.
     * </p>
     * 
     * @return Represents the content of a <code>Custom</code> type related item.
     */
    public final CustomFilter custom() {
        return custom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contact());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sla());
        hashCode = 31 * hashCode + Objects.hashCode(connectCase());
        hashCode = 31 * hashCode + Objects.hashCode(custom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemTypeFilter)) {
            return false;
        }
        RelatedItemTypeFilter other = (RelatedItemTypeFilter) obj;
        return Objects.equals(contact(), other.contact()) && Objects.equals(comment(), other.comment())
                && Objects.equals(file(), other.file()) && Objects.equals(sla(), other.sla())
                && Objects.equals(connectCase(), other.connectCase()) && Objects.equals(custom(), other.custom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedItemTypeFilter").add("Contact", contact()).add("Comment", comment()).add("File", file())
                .add("Sla", sla()).add("ConnectCase", connectCase()).add("Custom", custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contact":
            return Optional.ofNullable(clazz.cast(contact()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sla":
            return Optional.ofNullable(clazz.cast(sla()));
        case "connectCase":
            return Optional.ofNullable(clazz.cast(connectCase()));
        case "custom":
            return Optional.ofNullable(clazz.cast(custom()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #contact()} initialized to the given value.
     *
     * <p>
     * A filter for related items of type <code>Contact</code>.
     * </p>
     * 
     * @param contact
     *        A filter for related items of type <code>Contact</code>.
     */
    public static RelatedItemTypeFilter fromContact(ContactFilter contact) {
        return builder().contact(contact).build();
    }

    /**
     * Create an instance of this class with {@link #contact()} initialized to the given value.
     *
     * <p>
     * A filter for related items of type <code>Contact</code>.
     * </p>
     * 
     * @param contact
     *        A filter for related items of type <code>Contact</code>.
     */
    public static RelatedItemTypeFilter fromContact(Consumer<ContactFilter.Builder> contact) {
        ContactFilter.Builder builder = ContactFilter.builder();
        contact.accept(builder);
        return fromContact(builder.build());
    }

    /**
     * Create an instance of this class with {@link #comment()} initialized to the given value.
     *
     * <p>
     * A filter for related items of type <code>Comment</code>.
     * </p>
     * 
     * @param comment
     *        A filter for related items of type <code>Comment</code>.
     */
    public static RelatedItemTypeFilter fromComment(CommentFilter comment) {
        return builder().comment(comment).build();
    }

    /**
     * Create an instance of this class with {@link #comment()} initialized to the given value.
     *
     * <p>
     * A filter for related items of type <code>Comment</code>.
     * </p>
     * 
     * @param comment
     *        A filter for related items of type <code>Comment</code>.
     */
    public static RelatedItemTypeFilter fromComment(Consumer<CommentFilter.Builder> comment) {
        CommentFilter.Builder builder = CommentFilter.builder();
        comment.accept(builder);
        return fromComment(builder.build());
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * A filter for related items of this type of <code>File</code>.
     * </p>
     * 
     * @param file
     *        A filter for related items of this type of <code>File</code>.
     */
    public static RelatedItemTypeFilter fromFile(FileFilter file) {
        return builder().file(file).build();
    }

    /**
     * Create an instance of this class with {@link #file()} initialized to the given value.
     *
     * <p>
     * A filter for related items of this type of <code>File</code>.
     * </p>
     * 
     * @param file
     *        A filter for related items of this type of <code>File</code>.
     */
    public static RelatedItemTypeFilter fromFile(Consumer<FileFilter.Builder> file) {
        FileFilter.Builder builder = FileFilter.builder();
        file.accept(builder);
        return fromFile(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sla()} initialized to the given value.
     *
     * <p>
     * Filter for related items of type <code>SLA</code>.
     * </p>
     * 
     * @param sla
     *        Filter for related items of type <code>SLA</code>.
     */
    public static RelatedItemTypeFilter fromSla(SlaFilter sla) {
        return builder().sla(sla).build();
    }

    /**
     * Create an instance of this class with {@link #sla()} initialized to the given value.
     *
     * <p>
     * Filter for related items of type <code>SLA</code>.
     * </p>
     * 
     * @param sla
     *        Filter for related items of type <code>SLA</code>.
     */
    public static RelatedItemTypeFilter fromSla(Consumer<SlaFilter.Builder> sla) {
        SlaFilter.Builder builder = SlaFilter.builder();
        sla.accept(builder);
        return fromSla(builder.build());
    }

    /**
     * Create an instance of this class with {@link #connectCase()} initialized to the given value.
     *
     * <p>
     * Represents the Amazon Connect case to be created as a related item.
     * </p>
     * 
     * @param connectCase
     *        Represents the Amazon Connect case to be created as a related item.
     */
    public static RelatedItemTypeFilter fromConnectCase(ConnectCaseFilter connectCase) {
        return builder().connectCase(connectCase).build();
    }

    /**
     * Create an instance of this class with {@link #connectCase()} initialized to the given value.
     *
     * <p>
     * Represents the Amazon Connect case to be created as a related item.
     * </p>
     * 
     * @param connectCase
     *        Represents the Amazon Connect case to be created as a related item.
     */
    public static RelatedItemTypeFilter fromConnectCase(Consumer<ConnectCaseFilter.Builder> connectCase) {
        ConnectCaseFilter.Builder builder = ConnectCaseFilter.builder();
        connectCase.accept(builder);
        return fromConnectCase(builder.build());
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Represents the content of a <code>Custom</code> type related item.
     * </p>
     * 
     * @param custom
     *        Represents the content of a <code>Custom</code> type related item.
     */
    public static RelatedItemTypeFilter fromCustom(CustomFilter custom) {
        return builder().custom(custom).build();
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Represents the content of a <code>Custom</code> type related item.
     * </p>
     * 
     * @param custom
     *        Represents the content of a <code>Custom</code> type related item.
     */
    public static RelatedItemTypeFilter fromCustom(Consumer<CustomFilter.Builder> custom) {
        CustomFilter.Builder builder = CustomFilter.builder();
        custom.accept(builder);
        return fromCustom(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contact", CONTACT_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("file", FILE_FIELD);
        map.put("sla", SLA_FIELD);
        map.put("connectCase", CONNECT_CASE_FIELD);
        map.put("custom", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemTypeFilter, T> g) {
        return obj -> g.apply((RelatedItemTypeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedItemTypeFilter> {
        /**
         * <p>
         * A filter for related items of type <code>Contact</code>.
         * </p>
         * 
         * @param contact
         *        A filter for related items of type <code>Contact</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contact(ContactFilter contact);

        /**
         * <p>
         * A filter for related items of type <code>Contact</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFilter.Builder} avoiding the need
         * to create one manually via {@link ContactFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #contact(ContactFilter)}.
         * 
         * @param contact
         *        a consumer that will call methods on {@link ContactFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contact(ContactFilter)
         */
        default Builder contact(Consumer<ContactFilter.Builder> contact) {
            return contact(ContactFilter.builder().applyMutation(contact).build());
        }

        /**
         * <p>
         * A filter for related items of type <code>Comment</code>.
         * </p>
         * 
         * @param comment
         *        A filter for related items of type <code>Comment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(CommentFilter comment);

        /**
         * <p>
         * A filter for related items of type <code>Comment</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommentFilter.Builder} avoiding the need
         * to create one manually via {@link CommentFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommentFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #comment(CommentFilter)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link CommentFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(CommentFilter)
         */
        default Builder comment(Consumer<CommentFilter.Builder> comment) {
            return comment(CommentFilter.builder().applyMutation(comment).build());
        }

        /**
         * <p>
         * A filter for related items of this type of <code>File</code>.
         * </p>
         * 
         * @param file
         *        A filter for related items of this type of <code>File</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(FileFilter file);

        /**
         * <p>
         * A filter for related items of this type of <code>File</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileFilter.Builder} avoiding the need to
         * create one manually via {@link FileFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #file(FileFilter)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link FileFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(FileFilter)
         */
        default Builder file(Consumer<FileFilter.Builder> file) {
            return file(FileFilter.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * Filter for related items of type <code>SLA</code>.
         * </p>
         * 
         * @param sla
         *        Filter for related items of type <code>SLA</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sla(SlaFilter sla);

        /**
         * <p>
         * Filter for related items of type <code>SLA</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlaFilter.Builder} avoiding the need to
         * create one manually via {@link SlaFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlaFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #sla(SlaFilter)}.
         * 
         * @param sla
         *        a consumer that will call methods on {@link SlaFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sla(SlaFilter)
         */
        default Builder sla(Consumer<SlaFilter.Builder> sla) {
            return sla(SlaFilter.builder().applyMutation(sla).build());
        }

        /**
         * <p>
         * Represents the Amazon Connect case to be created as a related item.
         * </p>
         * 
         * @param connectCase
         *        Represents the Amazon Connect case to be created as a related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectCase(ConnectCaseFilter connectCase);

        /**
         * <p>
         * Represents the Amazon Connect case to be created as a related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectCaseFilter.Builder} avoiding the
         * need to create one manually via {@link ConnectCaseFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectCaseFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #connectCase(ConnectCaseFilter)}.
         * 
         * @param connectCase
         *        a consumer that will call methods on {@link ConnectCaseFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectCase(ConnectCaseFilter)
         */
        default Builder connectCase(Consumer<ConnectCaseFilter.Builder> connectCase) {
            return connectCase(ConnectCaseFilter.builder().applyMutation(connectCase).build());
        }

        /**
         * <p>
         * Represents the content of a <code>Custom</code> type related item.
         * </p>
         * 
         * @param custom
         *        Represents the content of a <code>Custom</code> type related item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(CustomFilter custom);

        /**
         * <p>
         * Represents the content of a <code>Custom</code> type related item.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomFilter.Builder} avoiding the need
         * to create one manually via {@link CustomFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #custom(CustomFilter)}.
         * 
         * @param custom
         *        a consumer that will call methods on {@link CustomFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(CustomFilter)
         */
        default Builder custom(Consumer<CustomFilter.Builder> custom) {
            return custom(CustomFilter.builder().applyMutation(custom).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContactFilter contact;

        private CommentFilter comment;

        private FileFilter file;

        private SlaFilter sla;

        private ConnectCaseFilter connectCase;

        private CustomFilter custom;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemTypeFilter model) {
            contact(model.contact);
            comment(model.comment);
            file(model.file);
            sla(model.sla);
            connectCase(model.connectCase);
            custom(model.custom);
        }

        public final ContactFilter.Builder getContact() {
            return contact != null ? contact.toBuilder() : null;
        }

        public final void setContact(ContactFilter.BuilderImpl contact) {
            Object oldValue = this.contact;
            this.contact = contact != null ? contact.build() : null;
            handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
        }

        @Override
        public final Builder contact(ContactFilter contact) {
            Object oldValue = this.contact;
            this.contact = contact;
            handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
            return this;
        }

        public final CommentFilter.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        public final void setComment(CommentFilter.BuilderImpl comment) {
            Object oldValue = this.comment;
            this.comment = comment != null ? comment.build() : null;
            handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
        }

        @Override
        public final Builder comment(CommentFilter comment) {
            Object oldValue = this.comment;
            this.comment = comment;
            handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
            return this;
        }

        public final FileFilter.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(FileFilter.BuilderImpl file) {
            Object oldValue = this.file;
            this.file = file != null ? file.build() : null;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(FileFilter file) {
            Object oldValue = this.file;
            this.file = file;
            handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final SlaFilter.Builder getSla() {
            return sla != null ? sla.toBuilder() : null;
        }

        public final void setSla(SlaFilter.BuilderImpl sla) {
            Object oldValue = this.sla;
            this.sla = sla != null ? sla.build() : null;
            handleUnionValueChange(Type.SLA, oldValue, this.sla);
        }

        @Override
        public final Builder sla(SlaFilter sla) {
            Object oldValue = this.sla;
            this.sla = sla;
            handleUnionValueChange(Type.SLA, oldValue, this.sla);
            return this;
        }

        public final ConnectCaseFilter.Builder getConnectCase() {
            return connectCase != null ? connectCase.toBuilder() : null;
        }

        public final void setConnectCase(ConnectCaseFilter.BuilderImpl connectCase) {
            Object oldValue = this.connectCase;
            this.connectCase = connectCase != null ? connectCase.build() : null;
            handleUnionValueChange(Type.CONNECT_CASE, oldValue, this.connectCase);
        }

        @Override
        public final Builder connectCase(ConnectCaseFilter connectCase) {
            Object oldValue = this.connectCase;
            this.connectCase = connectCase;
            handleUnionValueChange(Type.CONNECT_CASE, oldValue, this.connectCase);
            return this;
        }

        public final CustomFilter.Builder getCustom() {
            return custom != null ? custom.toBuilder() : null;
        }

        public final void setCustom(CustomFilter.BuilderImpl custom) {
            Object oldValue = this.custom;
            this.custom = custom != null ? custom.build() : null;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
        }

        @Override
        public final Builder custom(CustomFilter custom) {
            Object oldValue = this.custom;
            this.custom = custom;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
            return this;
        }

        @Override
        public RelatedItemTypeFilter build() {
            return new RelatedItemTypeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RelatedItemTypeFilter#type()
     */
    public enum Type {
        CONTACT,

        COMMENT,

        FILE,

        SLA,

        CONNECT_CASE,

        CUSTOM,

        UNKNOWN_TO_SDK_VERSION
    }
}
