/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed case rule information. In the Amazon Connect admin website, case rules are known as <i>case field
 * conditions</i>. For more information about case field conditions, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html">Add case field conditions to
 * a case template</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCaseRuleResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<GetCaseRuleResponse.Builder, GetCaseRuleResponse> {
    private static final SdkField<String> CASE_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseRuleId").getter(getter(GetCaseRuleResponse::caseRuleId)).setter(setter(Builder::caseRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetCaseRuleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CASE_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseRuleArn").getter(getter(GetCaseRuleResponse::caseRuleArn)).setter(setter(Builder::caseRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleArn").build()).build();

    private static final SdkField<CaseRuleDetails> RULE_FIELD = SdkField.<CaseRuleDetails> builder(MarshallingType.SDK_POJO)
            .memberName("rule").getter(getter(GetCaseRuleResponse::rule)).setter(setter(Builder::rule))
            .constructor(CaseRuleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCaseRuleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> DELETED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleted").getter(getter(GetCaseRuleResponse::deleted)).setter(setter(Builder::deleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleted").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime")
            .getter(getter(GetCaseRuleResponse::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(GetCaseRuleResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetCaseRuleResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULE_ID_FIELD,
            NAME_FIELD, CASE_RULE_ARN_FIELD, RULE_FIELD, DESCRIPTION_FIELD, DELETED_FIELD, CREATED_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String caseRuleId;

    private final String name;

    private final String caseRuleArn;

    private final CaseRuleDetails rule;

    private final String description;

    private final Boolean deleted;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final Map<String, String> tags;

    private GetCaseRuleResponse(BuilderImpl builder) {
        this.caseRuleId = builder.caseRuleId;
        this.name = builder.name;
        this.caseRuleArn = builder.caseRuleArn;
        this.rule = builder.rule;
        this.description = builder.description;
        this.deleted = builder.deleted;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique identifier of a case rule.
     * </p>
     * 
     * @return Unique identifier of a case rule.
     */
    public final String caseRuleId() {
        return caseRuleId;
    }

    /**
     * <p>
     * Name of the case rule.
     * </p>
     * 
     * @return Name of the case rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the case rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the case rule.
     */
    public final String caseRuleArn() {
        return caseRuleArn;
    }

    /**
     * <p>
     * Represents what rule type should take place, under what conditions.
     * </p>
     * 
     * @return Represents what rule type should take place, under what conditions.
     */
    public final CaseRuleDetails rule() {
        return rule;
    }

    /**
     * <p>
     * Description of a case rule.
     * </p>
     * 
     * @return Description of a case rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the resource has been deleted.
     * </p>
     * 
     * @return Indicates whether the resource has been deleted.
     */
    public final Boolean deleted() {
        return deleted;
    }

    /**
     * <p>
     * Timestamp when the resource was created.
     * </p>
     * 
     * @return Timestamp when the resource was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Timestamp when the resource was created or last modified.
     * </p>
     * 
     * @return Timestamp when the resource was created or last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
     * access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
     *         control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(caseRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deleted());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseRuleResponse)) {
            return false;
        }
        GetCaseRuleResponse other = (GetCaseRuleResponse) obj;
        return Objects.equals(caseRuleId(), other.caseRuleId()) && Objects.equals(name(), other.name())
                && Objects.equals(caseRuleArn(), other.caseRuleArn()) && Objects.equals(rule(), other.rule())
                && Objects.equals(description(), other.description()) && Objects.equals(deleted(), other.deleted())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCaseRuleResponse").add("CaseRuleId", caseRuleId()).add("Name", name())
                .add("CaseRuleArn", caseRuleArn()).add("Rule", rule()).add("Description", description())
                .add("Deleted", deleted()).add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseRuleId":
            return Optional.ofNullable(clazz.cast(caseRuleId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "caseRuleArn":
            return Optional.ofNullable(clazz.cast(caseRuleArn()));
        case "rule":
            return Optional.ofNullable(clazz.cast(rule()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "deleted":
            return Optional.ofNullable(clazz.cast(deleted()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseRuleId", CASE_RULE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("caseRuleArn", CASE_RULE_ARN_FIELD);
        map.put("rule", RULE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("deleted", DELETED_FIELD);
        map.put("createdTime", CREATED_TIME_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCaseRuleResponse, T> g) {
        return obj -> g.apply((GetCaseRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetCaseRuleResponse> {
        /**
         * <p>
         * Unique identifier of a case rule.
         * </p>
         * 
         * @param caseRuleId
         *        Unique identifier of a case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRuleId(String caseRuleId);

        /**
         * <p>
         * Name of the case rule.
         * </p>
         * 
         * @param name
         *        Name of the case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the case rule.
         * </p>
         * 
         * @param caseRuleArn
         *        The Amazon Resource Name (ARN) of the case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRuleArn(String caseRuleArn);

        /**
         * <p>
         * Represents what rule type should take place, under what conditions.
         * </p>
         * 
         * @param rule
         *        Represents what rule type should take place, under what conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(CaseRuleDetails rule);

        /**
         * <p>
         * Represents what rule type should take place, under what conditions.
         * </p>
         * This is a convenience method that creates an instance of the {@link CaseRuleDetails.Builder} avoiding the
         * need to create one manually via {@link CaseRuleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaseRuleDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #rule(CaseRuleDetails)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link CaseRuleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(CaseRuleDetails)
         */
        default Builder rule(Consumer<CaseRuleDetails.Builder> rule) {
            return rule(CaseRuleDetails.builder().applyMutation(rule).build());
        }

        /**
         * <p>
         * Description of a case rule.
         * </p>
         * 
         * @param description
         *        Description of a case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the resource has been deleted.
         * </p>
         * 
         * @param deleted
         *        Indicates whether the resource has been deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleted(Boolean deleted);

        /**
         * <p>
         * Timestamp when the resource was created.
         * </p>
         * 
         * @param createdTime
         *        Timestamp when the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Timestamp when the resource was created or last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        Timestamp when the resource was created or last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or control
         * access for this resource.
         * </p>
         * 
         * @param tags
         *        A map of of key-value pairs that represent tags on a resource. Tags are used to organize, track, or
         *        control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String caseRuleId;

        private String name;

        private String caseRuleArn;

        private CaseRuleDetails rule;

        private String description;

        private Boolean deleted;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCaseRuleResponse model) {
            caseRuleId(model.caseRuleId);
            name(model.name);
            caseRuleArn(model.caseRuleArn);
            rule(model.rule);
            description(model.description);
            deleted(model.deleted);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            tags(model.tags);
        }

        public final String getCaseRuleId() {
            return caseRuleId;
        }

        public final void setCaseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
        }

        @Override
        public final Builder caseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCaseRuleArn() {
            return caseRuleArn;
        }

        public final void setCaseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
        }

        @Override
        public final Builder caseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
            return this;
        }

        public final CaseRuleDetails.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(CaseRuleDetails.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(CaseRuleDetails rule) {
            this.rule = rule;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDeleted() {
            return deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetCaseRuleResponse build() {
            return new GetCaseRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
