/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents what rule type should take place, under what conditions. In the Amazon Connect admin website, case rules
 * are known as <i>case field conditions</i>. For more information about case field conditions, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html">Add case field conditions to
 * a case template</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseRuleDetails implements SdkPojo, Serializable, ToCopyableBuilder<CaseRuleDetails.Builder, CaseRuleDetails> {
    private static final SdkField<RequiredCaseRule> REQUIRED_FIELD = SdkField
            .<RequiredCaseRule> builder(MarshallingType.SDK_POJO).memberName("required")
            .getter(getter(CaseRuleDetails::required)).setter(setter(Builder::required)).constructor(RequiredCaseRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build()).build();

    private static final SdkField<FieldOptionsCaseRule> FIELD_OPTIONS_FIELD = SdkField
            .<FieldOptionsCaseRule> builder(MarshallingType.SDK_POJO).memberName("fieldOptions")
            .getter(getter(CaseRuleDetails::fieldOptions)).setter(setter(Builder::fieldOptions))
            .constructor(FieldOptionsCaseRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldOptions").build()).build();

    private static final SdkField<HiddenCaseRule> HIDDEN_FIELD = SdkField.<HiddenCaseRule> builder(MarshallingType.SDK_POJO)
            .memberName("hidden").getter(getter(CaseRuleDetails::hidden)).setter(setter(Builder::hidden))
            .constructor(HiddenCaseRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hidden").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRED_FIELD,
            FIELD_OPTIONS_FIELD, HIDDEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RequiredCaseRule required;

    private final FieldOptionsCaseRule fieldOptions;

    private final HiddenCaseRule hidden;

    private final Type type;

    private CaseRuleDetails(BuilderImpl builder) {
        this.required = builder.required;
        this.fieldOptions = builder.fieldOptions;
        this.hidden = builder.hidden;
        this.type = builder.type;
    }

    /**
     * <p>
     * Required rule type, used to indicate whether a field is required.
     * </p>
     * 
     * @return Required rule type, used to indicate whether a field is required.
     */
    public final RequiredCaseRule required() {
        return required;
    }

    /**
     * <p>
     * Which options are available in a child field based on the selected value in a parent field.
     * </p>
     * 
     * @return Which options are available in a child field based on the selected value in a parent field.
     */
    public final FieldOptionsCaseRule fieldOptions() {
        return fieldOptions;
    }

    /**
     * <p>
     * Whether a field is visible, based on values in other fields.
     * </p>
     * 
     * @return Whether a field is visible, based on values in other fields.
     */
    public final HiddenCaseRule hidden() {
        return hidden;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(fieldOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hidden());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseRuleDetails)) {
            return false;
        }
        CaseRuleDetails other = (CaseRuleDetails) obj;
        return Objects.equals(required(), other.required()) && Objects.equals(fieldOptions(), other.fieldOptions())
                && Objects.equals(hidden(), other.hidden());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaseRuleDetails").add("Required", required()).add("FieldOptions", fieldOptions())
                .add("Hidden", hidden()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "required":
            return Optional.ofNullable(clazz.cast(required()));
        case "fieldOptions":
            return Optional.ofNullable(clazz.cast(fieldOptions()));
        case "hidden":
            return Optional.ofNullable(clazz.cast(hidden()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #required()} initialized to the given value.
     *
     * <p>
     * Required rule type, used to indicate whether a field is required.
     * </p>
     * 
     * @param required
     *        Required rule type, used to indicate whether a field is required.
     */
    public static CaseRuleDetails fromRequired(RequiredCaseRule required) {
        return builder().required(required).build();
    }

    /**
     * Create an instance of this class with {@link #required()} initialized to the given value.
     *
     * <p>
     * Required rule type, used to indicate whether a field is required.
     * </p>
     * 
     * @param required
     *        Required rule type, used to indicate whether a field is required.
     */
    public static CaseRuleDetails fromRequired(Consumer<RequiredCaseRule.Builder> required) {
        RequiredCaseRule.Builder builder = RequiredCaseRule.builder();
        required.accept(builder);
        return fromRequired(builder.build());
    }

    /**
     * Create an instance of this class with {@link #fieldOptions()} initialized to the given value.
     *
     * <p>
     * Which options are available in a child field based on the selected value in a parent field.
     * </p>
     * 
     * @param fieldOptions
     *        Which options are available in a child field based on the selected value in a parent field.
     */
    public static CaseRuleDetails fromFieldOptions(FieldOptionsCaseRule fieldOptions) {
        return builder().fieldOptions(fieldOptions).build();
    }

    /**
     * Create an instance of this class with {@link #fieldOptions()} initialized to the given value.
     *
     * <p>
     * Which options are available in a child field based on the selected value in a parent field.
     * </p>
     * 
     * @param fieldOptions
     *        Which options are available in a child field based on the selected value in a parent field.
     */
    public static CaseRuleDetails fromFieldOptions(Consumer<FieldOptionsCaseRule.Builder> fieldOptions) {
        FieldOptionsCaseRule.Builder builder = FieldOptionsCaseRule.builder();
        fieldOptions.accept(builder);
        return fromFieldOptions(builder.build());
    }

    /**
     * Create an instance of this class with {@link #hidden()} initialized to the given value.
     *
     * <p>
     * Whether a field is visible, based on values in other fields.
     * </p>
     * 
     * @param hidden
     *        Whether a field is visible, based on values in other fields.
     */
    public static CaseRuleDetails fromHidden(HiddenCaseRule hidden) {
        return builder().hidden(hidden).build();
    }

    /**
     * Create an instance of this class with {@link #hidden()} initialized to the given value.
     *
     * <p>
     * Whether a field is visible, based on values in other fields.
     * </p>
     * 
     * @param hidden
     *        Whether a field is visible, based on values in other fields.
     */
    public static CaseRuleDetails fromHidden(Consumer<HiddenCaseRule.Builder> hidden) {
        HiddenCaseRule.Builder builder = HiddenCaseRule.builder();
        hidden.accept(builder);
        return fromHidden(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("required", REQUIRED_FIELD);
        map.put("fieldOptions", FIELD_OPTIONS_FIELD);
        map.put("hidden", HIDDEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseRuleDetails, T> g) {
        return obj -> g.apply((CaseRuleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseRuleDetails> {
        /**
         * <p>
         * Required rule type, used to indicate whether a field is required.
         * </p>
         * 
         * @param required
         *        Required rule type, used to indicate whether a field is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(RequiredCaseRule required);

        /**
         * <p>
         * Required rule type, used to indicate whether a field is required.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequiredCaseRule.Builder} avoiding the
         * need to create one manually via {@link RequiredCaseRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequiredCaseRule.Builder#build()} is called immediately and its
         * result is passed to {@link #required(RequiredCaseRule)}.
         * 
         * @param required
         *        a consumer that will call methods on {@link RequiredCaseRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #required(RequiredCaseRule)
         */
        default Builder required(Consumer<RequiredCaseRule.Builder> required) {
            return required(RequiredCaseRule.builder().applyMutation(required).build());
        }

        /**
         * <p>
         * Which options are available in a child field based on the selected value in a parent field.
         * </p>
         * 
         * @param fieldOptions
         *        Which options are available in a child field based on the selected value in a parent field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldOptions(FieldOptionsCaseRule fieldOptions);

        /**
         * <p>
         * Which options are available in a child field based on the selected value in a parent field.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldOptionsCaseRule.Builder} avoiding
         * the need to create one manually via {@link FieldOptionsCaseRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldOptionsCaseRule.Builder#build()} is called immediately and
         * its result is passed to {@link #fieldOptions(FieldOptionsCaseRule)}.
         * 
         * @param fieldOptions
         *        a consumer that will call methods on {@link FieldOptionsCaseRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldOptions(FieldOptionsCaseRule)
         */
        default Builder fieldOptions(Consumer<FieldOptionsCaseRule.Builder> fieldOptions) {
            return fieldOptions(FieldOptionsCaseRule.builder().applyMutation(fieldOptions).build());
        }

        /**
         * <p>
         * Whether a field is visible, based on values in other fields.
         * </p>
         * 
         * @param hidden
         *        Whether a field is visible, based on values in other fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hidden(HiddenCaseRule hidden);

        /**
         * <p>
         * Whether a field is visible, based on values in other fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link HiddenCaseRule.Builder} avoiding the need
         * to create one manually via {@link HiddenCaseRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HiddenCaseRule.Builder#build()} is called immediately and its
         * result is passed to {@link #hidden(HiddenCaseRule)}.
         * 
         * @param hidden
         *        a consumer that will call methods on {@link HiddenCaseRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hidden(HiddenCaseRule)
         */
        default Builder hidden(Consumer<HiddenCaseRule.Builder> hidden) {
            return hidden(HiddenCaseRule.builder().applyMutation(hidden).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RequiredCaseRule required;

        private FieldOptionsCaseRule fieldOptions;

        private HiddenCaseRule hidden;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CaseRuleDetails model) {
            required(model.required);
            fieldOptions(model.fieldOptions);
            hidden(model.hidden);
        }

        public final RequiredCaseRule.Builder getRequired() {
            return required != null ? required.toBuilder() : null;
        }

        public final void setRequired(RequiredCaseRule.BuilderImpl required) {
            Object oldValue = this.required;
            this.required = required != null ? required.build() : null;
            handleUnionValueChange(Type.REQUIRED, oldValue, this.required);
        }

        @Override
        public final Builder required(RequiredCaseRule required) {
            Object oldValue = this.required;
            this.required = required;
            handleUnionValueChange(Type.REQUIRED, oldValue, this.required);
            return this;
        }

        public final FieldOptionsCaseRule.Builder getFieldOptions() {
            return fieldOptions != null ? fieldOptions.toBuilder() : null;
        }

        public final void setFieldOptions(FieldOptionsCaseRule.BuilderImpl fieldOptions) {
            Object oldValue = this.fieldOptions;
            this.fieldOptions = fieldOptions != null ? fieldOptions.build() : null;
            handleUnionValueChange(Type.FIELD_OPTIONS, oldValue, this.fieldOptions);
        }

        @Override
        public final Builder fieldOptions(FieldOptionsCaseRule fieldOptions) {
            Object oldValue = this.fieldOptions;
            this.fieldOptions = fieldOptions;
            handleUnionValueChange(Type.FIELD_OPTIONS, oldValue, this.fieldOptions);
            return this;
        }

        public final HiddenCaseRule.Builder getHidden() {
            return hidden != null ? hidden.toBuilder() : null;
        }

        public final void setHidden(HiddenCaseRule.BuilderImpl hidden) {
            Object oldValue = this.hidden;
            this.hidden = hidden != null ? hidden.build() : null;
            handleUnionValueChange(Type.HIDDEN, oldValue, this.hidden);
        }

        @Override
        public final Builder hidden(HiddenCaseRule hidden) {
            Object oldValue = this.hidden;
            this.hidden = hidden;
            handleUnionValueChange(Type.HIDDEN, oldValue, this.hidden);
            return this;
        }

        @Override
        public CaseRuleDetails build() {
            return new CaseRuleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CaseRuleDetails#type()
     */
    public enum Type {
        REQUIRED,

        FIELD_OPTIONS,

        HIDDEN,

        UNKNOWN_TO_SDK_VERSION
    }
}
