/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BooleanConditionListCopier {
    static List<BooleanCondition> copy(Collection<? extends BooleanCondition> booleanConditionListParam) {
        List<BooleanCondition> list;
        if (booleanConditionListParam == null || booleanConditionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BooleanCondition> modifiableList = new ArrayList<>(booleanConditionListParam.size());
            booleanConditionListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BooleanCondition> copyFromBuilder(Collection<? extends BooleanCondition.Builder> booleanConditionListParam) {
        List<BooleanCondition> list;
        if (booleanConditionListParam == null || booleanConditionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BooleanCondition> modifiableList = new ArrayList<>(booleanConditionListParam.size());
            booleanConditionListParam.forEach(entry -> {
                BooleanCondition member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<BooleanCondition.Builder> copyToBuilder(Collection<? extends BooleanCondition> booleanConditionListParam) {
        List<BooleanCondition.Builder> list;
        if (booleanConditionListParam == null || booleanConditionListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<BooleanCondition.Builder> modifiableList = new ArrayList<>(booleanConditionListParam.size());
            booleanConditionListParam.forEach(entry -> {
                BooleanCondition.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
