/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Content specific to <code>BasicLayout</code> type. It configures fields in the top panel and More Info tab of agent
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BasicLayout implements SdkPojo, Serializable, ToCopyableBuilder<BasicLayout.Builder, BasicLayout> {
    private static final SdkField<LayoutSections> TOP_PANEL_FIELD = SdkField.<LayoutSections> builder(MarshallingType.SDK_POJO)
            .memberName("topPanel").getter(getter(BasicLayout::topPanel)).setter(setter(Builder::topPanel))
            .constructor(LayoutSections::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topPanel").build()).build();

    private static final SdkField<LayoutSections> MORE_INFO_FIELD = SdkField.<LayoutSections> builder(MarshallingType.SDK_POJO)
            .memberName("moreInfo").getter(getter(BasicLayout::moreInfo)).setter(setter(Builder::moreInfo))
            .constructor(LayoutSections::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moreInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOP_PANEL_FIELD,
            MORE_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LayoutSections topPanel;

    private final LayoutSections moreInfo;

    private BasicLayout(BuilderImpl builder) {
        this.topPanel = builder.topPanel;
        this.moreInfo = builder.moreInfo;
    }

    /**
     * <p>
     * This represents sections in a panel of the page layout.
     * </p>
     * 
     * @return This represents sections in a panel of the page layout.
     */
    public final LayoutSections topPanel() {
        return topPanel;
    }

    /**
     * <p>
     * This represents sections in a tab of the page layout.
     * </p>
     * 
     * @return This represents sections in a tab of the page layout.
     */
    public final LayoutSections moreInfo() {
        return moreInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topPanel());
        hashCode = 31 * hashCode + Objects.hashCode(moreInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicLayout)) {
            return false;
        }
        BasicLayout other = (BasicLayout) obj;
        return Objects.equals(topPanel(), other.topPanel()) && Objects.equals(moreInfo(), other.moreInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BasicLayout").add("TopPanel", topPanel()).add("MoreInfo", moreInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topPanel":
            return Optional.ofNullable(clazz.cast(topPanel()));
        case "moreInfo":
            return Optional.ofNullable(clazz.cast(moreInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("topPanel", TOP_PANEL_FIELD);
        map.put("moreInfo", MORE_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BasicLayout, T> g) {
        return obj -> g.apply((BasicLayout) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BasicLayout> {
        /**
         * <p>
         * This represents sections in a panel of the page layout.
         * </p>
         * 
         * @param topPanel
         *        This represents sections in a panel of the page layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topPanel(LayoutSections topPanel);

        /**
         * <p>
         * This represents sections in a panel of the page layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutSections.Builder} avoiding the need
         * to create one manually via {@link LayoutSections#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutSections.Builder#build()} is called immediately and its
         * result is passed to {@link #topPanel(LayoutSections)}.
         * 
         * @param topPanel
         *        a consumer that will call methods on {@link LayoutSections.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topPanel(LayoutSections)
         */
        default Builder topPanel(Consumer<LayoutSections.Builder> topPanel) {
            return topPanel(LayoutSections.builder().applyMutation(topPanel).build());
        }

        /**
         * <p>
         * This represents sections in a tab of the page layout.
         * </p>
         * 
         * @param moreInfo
         *        This represents sections in a tab of the page layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder moreInfo(LayoutSections moreInfo);

        /**
         * <p>
         * This represents sections in a tab of the page layout.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutSections.Builder} avoiding the need
         * to create one manually via {@link LayoutSections#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutSections.Builder#build()} is called immediately and its
         * result is passed to {@link #moreInfo(LayoutSections)}.
         * 
         * @param moreInfo
         *        a consumer that will call methods on {@link LayoutSections.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #moreInfo(LayoutSections)
         */
        default Builder moreInfo(Consumer<LayoutSections.Builder> moreInfo) {
            return moreInfo(LayoutSections.builder().applyMutation(moreInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LayoutSections topPanel;

        private LayoutSections moreInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(BasicLayout model) {
            topPanel(model.topPanel);
            moreInfo(model.moreInfo);
        }

        public final LayoutSections.Builder getTopPanel() {
            return topPanel != null ? topPanel.toBuilder() : null;
        }

        public final void setTopPanel(LayoutSections.BuilderImpl topPanel) {
            this.topPanel = topPanel != null ? topPanel.build() : null;
        }

        @Override
        public final Builder topPanel(LayoutSections topPanel) {
            this.topPanel = topPanel;
            return this;
        }

        public final LayoutSections.Builder getMoreInfo() {
            return moreInfo != null ? moreInfo.toBuilder() : null;
        }

        public final void setMoreInfo(LayoutSections.BuilderImpl moreInfo) {
            this.moreInfo = moreInfo != null ? moreInfo.build() : null;
        }

        @Override
        public final Builder moreInfo(LayoutSections moreInfo) {
            this.moreInfo = moreInfo;
            return this;
        }

        @Override
        public BasicLayout build() {
            return new BasicLayout(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
