/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.ListDomainsRequest;
import software.amazon.awssdk.services.connectcases.model.ListDomainsResponse;

public class ListDomainsIterable
implements SdkIterable<ListDomainsResponse> {
    private final ConnectCasesClient client;
    private final ListDomainsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainsIterable(ConnectCasesClient client, ListDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainsResponseFetcher();
    }

    public Iterator<ListDomainsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDomainsResponseFetcher
    implements SyncPageFetcher<ListDomainsResponse> {
        private ListDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainsResponse nextPage(ListDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsIterable.this.client.listDomains(ListDomainsIterable.this.firstRequest);
            }
            return ListDomainsIterable.this.client.listDomains((ListDomainsRequest)((Object)ListDomainsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

