/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of types of related items and their parameters to use for filtering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedItemTypeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedItemTypeFilter.Builder, RelatedItemTypeFilter> {
    private static final SdkField<CommentFilter> COMMENT_FIELD = SdkField.<CommentFilter> builder(MarshallingType.SDK_POJO)
            .memberName("comment").getter(getter(RelatedItemTypeFilter::comment)).setter(setter(Builder::comment))
            .constructor(CommentFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<ContactFilter> CONTACT_FIELD = SdkField.<ContactFilter> builder(MarshallingType.SDK_POJO)
            .memberName("contact").getter(getter(RelatedItemTypeFilter::contact)).setter(setter(Builder::contact))
            .constructor(ContactFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, CONTACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final CommentFilter comment;

    private final ContactFilter contact;

    private final Type type;

    private RelatedItemTypeFilter(BuilderImpl builder) {
        this.comment = builder.comment;
        this.contact = builder.contact;
        this.type = builder.type;
    }

    /**
     * <p>
     * A filter for related items of type <code>Comment</code>.
     * </p>
     * 
     * @return A filter for related items of type <code>Comment</code>.
     */
    public final CommentFilter comment() {
        return comment;
    }

    /**
     * <p>
     * A filter for related items of type <code>Contact</code>.
     * </p>
     * 
     * @return A filter for related items of type <code>Contact</code>.
     */
    public final ContactFilter contact() {
        return contact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(contact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemTypeFilter)) {
            return false;
        }
        RelatedItemTypeFilter other = (RelatedItemTypeFilter) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(contact(), other.contact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedItemTypeFilter").add("Comment", comment()).add("Contact", contact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "contact":
            return Optional.ofNullable(clazz.cast(contact()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #comment()} initialized to the given value.
     *
     * <p>
     * A filter for related items of type <code>Comment</code>.
     * </p>
     * 
     * @param comment
     *        A filter for related items of type <code>Comment</code>.
     */
    public static RelatedItemTypeFilter fromComment(CommentFilter comment) {
        return builder().comment(comment).build();
    }

    /**
     * Create an instance of this class with {@link #comment()} initialized to the given value.
     *
     * <p>
     * A filter for related items of type <code>Comment</code>.
     * </p>
     * 
     * @param comment
     *        A filter for related items of type <code>Comment</code>.
     */
    public static RelatedItemTypeFilter fromComment(Consumer<CommentFilter.Builder> comment) {
        CommentFilter.Builder builder = CommentFilter.builder();
        comment.accept(builder);
        return fromComment(builder.build());
    }

    /**
     * Create an instance of this class with {@link #contact()} initialized to the given value.
     *
     * <p>
     * A filter for related items of type <code>Contact</code>.
     * </p>
     * 
     * @param contact
     *        A filter for related items of type <code>Contact</code>.
     */
    public static RelatedItemTypeFilter fromContact(ContactFilter contact) {
        return builder().contact(contact).build();
    }

    /**
     * Create an instance of this class with {@link #contact()} initialized to the given value.
     *
     * <p>
     * A filter for related items of type <code>Contact</code>.
     * </p>
     * 
     * @param contact
     *        A filter for related items of type <code>Contact</code>.
     */
    public static RelatedItemTypeFilter fromContact(Consumer<ContactFilter.Builder> contact) {
        ContactFilter.Builder builder = ContactFilter.builder();
        contact.accept(builder);
        return fromContact(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemTypeFilter, T> g) {
        return obj -> g.apply((RelatedItemTypeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedItemTypeFilter> {
        /**
         * <p>
         * A filter for related items of type <code>Comment</code>.
         * </p>
         * 
         * @param comment
         *        A filter for related items of type <code>Comment</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(CommentFilter comment);

        /**
         * <p>
         * A filter for related items of type <code>Comment</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommentFilter.Builder} avoiding the need
         * to create one manually via {@link CommentFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommentFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #comment(CommentFilter)}.
         * 
         * @param comment
         *        a consumer that will call methods on {@link CommentFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #comment(CommentFilter)
         */
        default Builder comment(Consumer<CommentFilter.Builder> comment) {
            return comment(CommentFilter.builder().applyMutation(comment).build());
        }

        /**
         * <p>
         * A filter for related items of type <code>Contact</code>.
         * </p>
         * 
         * @param contact
         *        A filter for related items of type <code>Contact</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contact(ContactFilter contact);

        /**
         * <p>
         * A filter for related items of type <code>Contact</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFilter.Builder} avoiding the need
         * to create one manually via {@link ContactFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #contact(ContactFilter)}.
         * 
         * @param contact
         *        a consumer that will call methods on {@link ContactFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contact(ContactFilter)
         */
        default Builder contact(Consumer<ContactFilter.Builder> contact) {
            return contact(ContactFilter.builder().applyMutation(contact).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CommentFilter comment;

        private ContactFilter contact;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemTypeFilter model) {
            comment(model.comment);
            contact(model.contact);
        }

        public final CommentFilter.Builder getComment() {
            return comment != null ? comment.toBuilder() : null;
        }

        public final void setComment(CommentFilter.BuilderImpl comment) {
            Object oldValue = this.comment;
            this.comment = comment != null ? comment.build() : null;
            handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
        }

        @Override
        public final Builder comment(CommentFilter comment) {
            Object oldValue = this.comment;
            this.comment = comment;
            handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
            return this;
        }

        public final ContactFilter.Builder getContact() {
            return contact != null ? contact.toBuilder() : null;
        }

        public final void setContact(ContactFilter.BuilderImpl contact) {
            Object oldValue = this.contact;
            this.contact = contact != null ? contact.build() : null;
            handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
        }

        @Override
        public final Builder contact(ContactFilter contact) {
            Object oldValue = this.contact;
            this.contact = contact;
            handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
            return this;
        }

        @Override
        public RelatedItemTypeFilter build() {
            return new RelatedItemTypeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RelatedItemTypeFilter#type()
     */
    public enum Type {
        COMMENT,

        CONTACT,

        UNKNOWN_TO_SDK_VERSION
    }
}
