/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest;
import software.amazon.awssdk.services.connectcases.model.ListCasesForContactResponse;

public class ListCasesForContactPublisher
implements SdkPublisher<ListCasesForContactResponse> {
    private final ConnectCasesAsyncClient client;
    private final ListCasesForContactRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCasesForContactPublisher(ConnectCasesAsyncClient client, ListCasesForContactRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCasesForContactPublisher(ConnectCasesAsyncClient client, ListCasesForContactRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCasesForContactResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCasesForContactResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCasesForContactResponseFetcher
    implements AsyncPageFetcher<ListCasesForContactResponse> {
        private ListCasesForContactResponseFetcher() {
        }

        public boolean hasNextPage(ListCasesForContactResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCasesForContactResponse> nextPage(ListCasesForContactResponse previousPage) {
            if (previousPage == null) {
                return ListCasesForContactPublisher.this.client.listCasesForContact(ListCasesForContactPublisher.this.firstRequest);
            }
            return ListCasesForContactPublisher.this.client.listCasesForContact((ListCasesForContactRequest)((Object)ListCasesForContactPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

