/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaignsv2.model.AgentAction;
import software.amazon.awssdk.services.connectcampaignsv2.model.AgentActionsCopier;
import software.amazon.awssdk.services.connectcampaignsv2.model.TimeoutConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreviewConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PreviewConfig> {
    private static final SdkField<Double> BANDWIDTH_ALLOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("bandwidthAllocation").getter(PreviewConfig.getter(PreviewConfig::bandwidthAllocation)).setter(PreviewConfig.setter(Builder::bandwidthAllocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthAllocation").build()}).build();
    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeoutConfig").getter(PreviewConfig.getter(PreviewConfig::timeoutConfig)).setter(PreviewConfig.setter(Builder::timeoutConfig)).constructor(TimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final SdkField<List<String>> AGENT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentActions").getter(PreviewConfig.getter(PreviewConfig::agentActionsAsStrings)).setter(PreviewConfig.setter(Builder::agentActionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BANDWIDTH_ALLOCATION_FIELD, TIMEOUT_CONFIG_FIELD, AGENT_ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PreviewConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double bandwidthAllocation;
    private final TimeoutConfig timeoutConfig;
    private final List<String> agentActions;

    private PreviewConfig(BuilderImpl builder) {
        this.bandwidthAllocation = builder.bandwidthAllocation;
        this.timeoutConfig = builder.timeoutConfig;
        this.agentActions = builder.agentActions;
    }

    public final Double bandwidthAllocation() {
        return this.bandwidthAllocation;
    }

    public final TimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public final List<AgentAction> agentActions() {
        return AgentActionsCopier.copyStringToEnum(this.agentActions);
    }

    public final boolean hasAgentActions() {
        return this.agentActions != null && !(this.agentActions instanceof SdkAutoConstructList);
    }

    public final List<String> agentActionsAsStrings() {
        return this.agentActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidthAllocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentActions() ? this.agentActionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreviewConfig)) {
            return false;
        }
        PreviewConfig other = (PreviewConfig)obj;
        return Objects.equals(this.bandwidthAllocation(), other.bandwidthAllocation()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig()) && this.hasAgentActions() == other.hasAgentActions() && Objects.equals(this.agentActionsAsStrings(), other.agentActionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PreviewConfig").add("BandwidthAllocation", (Object)this.bandwidthAllocation()).add("TimeoutConfig", (Object)this.timeoutConfig()).add("AgentActions", this.hasAgentActions() ? this.agentActionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bandwidthAllocation": {
                return Optional.ofNullable(clazz.cast(this.bandwidthAllocation()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
            case "agentActions": {
                return Optional.ofNullable(clazz.cast(this.agentActionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bandwidthAllocation", BANDWIDTH_ALLOCATION_FIELD);
        map.put("timeoutConfig", TIMEOUT_CONFIG_FIELD);
        map.put("agentActions", AGENT_ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreviewConfig, T> g) {
        return obj -> g.apply((PreviewConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double bandwidthAllocation;
        private TimeoutConfig timeoutConfig;
        private List<String> agentActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PreviewConfig model) {
            this.bandwidthAllocation(model.bandwidthAllocation);
            this.timeoutConfig(model.timeoutConfig);
            this.agentActionsWithStrings(model.agentActions);
        }

        public final Double getBandwidthAllocation() {
            return this.bandwidthAllocation;
        }

        public final void setBandwidthAllocation(Double bandwidthAllocation) {
            this.bandwidthAllocation = bandwidthAllocation;
        }

        @Override
        public final Builder bandwidthAllocation(Double bandwidthAllocation) {
            this.bandwidthAllocation = bandwidthAllocation;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final Collection<String> getAgentActions() {
            if (this.agentActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentActions;
        }

        public final void setAgentActions(Collection<String> agentActions) {
            this.agentActions = AgentActionsCopier.copy(agentActions);
        }

        @Override
        public final Builder agentActionsWithStrings(Collection<String> agentActions) {
            this.agentActions = AgentActionsCopier.copy(agentActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentActionsWithStrings(String ... agentActions) {
            this.agentActionsWithStrings(Arrays.asList(agentActions));
            return this;
        }

        @Override
        public final Builder agentActions(Collection<AgentAction> agentActions) {
            this.agentActions = AgentActionsCopier.copyEnumToString(agentActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentActions(AgentAction ... agentActions) {
            this.agentActions(Arrays.asList(agentActions));
            return this;
        }

        public PreviewConfig build() {
            return new PreviewConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PreviewConfig> {
        public Builder bandwidthAllocation(Double var1);

        public Builder timeoutConfig(TimeoutConfig var1);

        default public Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return this.timeoutConfig((TimeoutConfig)((TimeoutConfig.Builder)TimeoutConfig.builder().applyMutation(timeoutConfig)).build());
        }

        public Builder agentActionsWithStrings(Collection<String> var1);

        public Builder agentActionsWithStrings(String ... var1);

        public Builder agentActions(Collection<AgentAction> var1);

        public Builder agentActions(AgentAction ... var1);
    }
}

