/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcampaignsv2.model.ChannelSubtypeParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutboundRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutboundRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(OutboundRequest.getter(OutboundRequest::clientToken)).setter(OutboundRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationTime").getter(OutboundRequest.getter(OutboundRequest::expirationTime)).setter(OutboundRequest.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ChannelSubtypeParameters> CHANNEL_SUBTYPE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channelSubtypeParameters").getter(OutboundRequest.getter(OutboundRequest::channelSubtypeParameters)).setter(OutboundRequest.setter(Builder::channelSubtypeParameters)).constructor(ChannelSubtypeParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtypeParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, EXPIRATION_TIME_FIELD, CHANNEL_SUBTYPE_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutboundRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientToken;
    private final Instant expirationTime;
    private final ChannelSubtypeParameters channelSubtypeParameters;

    private OutboundRequest(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.expirationTime = builder.expirationTime;
        this.channelSubtypeParameters = builder.channelSubtypeParameters;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final ChannelSubtypeParameters channelSubtypeParameters() {
        return this.channelSubtypeParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelSubtypeParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundRequest)) {
            return false;
        }
        OutboundRequest other = (OutboundRequest)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.channelSubtypeParameters(), other.channelSubtypeParameters());
    }

    public final String toString() {
        return ToString.builder((String)"OutboundRequest").add("ClientToken", (Object)this.clientToken()).add("ExpirationTime", (Object)this.expirationTime()).add("ChannelSubtypeParameters", (Object)this.channelSubtypeParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "expirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "channelSubtypeParameters": {
                return Optional.ofNullable(clazz.cast(this.channelSubtypeParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("expirationTime", EXPIRATION_TIME_FIELD);
        map.put("channelSubtypeParameters", CHANNEL_SUBTYPE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundRequest, T> g) {
        return obj -> g.apply((OutboundRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Instant expirationTime;
        private ChannelSubtypeParameters channelSubtypeParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundRequest model) {
            this.clientToken(model.clientToken);
            this.expirationTime(model.expirationTime);
            this.channelSubtypeParameters(model.channelSubtypeParameters);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final ChannelSubtypeParameters.Builder getChannelSubtypeParameters() {
            return this.channelSubtypeParameters != null ? this.channelSubtypeParameters.toBuilder() : null;
        }

        public final void setChannelSubtypeParameters(ChannelSubtypeParameters.BuilderImpl channelSubtypeParameters) {
            this.channelSubtypeParameters = channelSubtypeParameters != null ? channelSubtypeParameters.build() : null;
        }

        @Override
        public final Builder channelSubtypeParameters(ChannelSubtypeParameters channelSubtypeParameters) {
            this.channelSubtypeParameters = channelSubtypeParameters;
            return this;
        }

        public OutboundRequest build() {
            return new OutboundRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutboundRequest> {
        public Builder clientToken(String var1);

        public Builder expirationTime(Instant var1);

        public Builder channelSubtypeParameters(ChannelSubtypeParameters var1);

        default public Builder channelSubtypeParameters(Consumer<ChannelSubtypeParameters.Builder> channelSubtypeParameters) {
            return this.channelSubtypeParameters((ChannelSubtypeParameters)((ChannelSubtypeParameters.Builder)ChannelSubtypeParameters.builder().applyMutation(channelSubtypeParameters)).build());
        }
    }
}

