/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.CustomerProfilesIntegrationSummary;
import software.amazon.awssdk.services.connectcampaignsv2.model.LambdaIntegrationSummary;
import software.amazon.awssdk.services.connectcampaignsv2.model.QConnectIntegrationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegrationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegrationSummary> {
    private static final SdkField<CustomerProfilesIntegrationSummary> CUSTOMER_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerProfiles").getter(IntegrationSummary.getter(IntegrationSummary::customerProfiles)).setter(IntegrationSummary.setter(Builder::customerProfiles)).constructor(CustomerProfilesIntegrationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProfiles").build()}).build();
    private static final SdkField<QConnectIntegrationSummary> Q_CONNECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qConnect").getter(IntegrationSummary.getter(IntegrationSummary::qConnect)).setter(IntegrationSummary.setter(Builder::qConnect)).constructor(QConnectIntegrationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qConnect").build()}).build();
    private static final SdkField<LambdaIntegrationSummary> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambda").getter(IntegrationSummary.getter(IntegrationSummary::lambda)).setter(IntegrationSummary.setter(Builder::lambda)).constructor(LambdaIntegrationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_PROFILES_FIELD, Q_CONNECT_FIELD, LAMBDA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IntegrationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CustomerProfilesIntegrationSummary customerProfiles;
    private final QConnectIntegrationSummary qConnect;
    private final LambdaIntegrationSummary lambda;
    private final Type type;

    private IntegrationSummary(BuilderImpl builder) {
        this.customerProfiles = builder.customerProfiles;
        this.qConnect = builder.qConnect;
        this.lambda = builder.lambda;
        this.type = builder.type;
    }

    public final CustomerProfilesIntegrationSummary customerProfiles() {
        return this.customerProfiles;
    }

    public final QConnectIntegrationSummary qConnect() {
        return this.qConnect;
    }

    public final LambdaIntegrationSummary lambda() {
        return this.lambda;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.qConnect());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationSummary)) {
            return false;
        }
        IntegrationSummary other = (IntegrationSummary)obj;
        return Objects.equals(this.customerProfiles(), other.customerProfiles()) && Objects.equals(this.qConnect(), other.qConnect()) && Objects.equals(this.lambda(), other.lambda());
    }

    public final String toString() {
        return ToString.builder((String)"IntegrationSummary").add("CustomerProfiles", (Object)this.customerProfiles()).add("QConnect", (Object)this.qConnect()).add("Lambda", (Object)this.lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customerProfiles": {
                return Optional.ofNullable(clazz.cast(this.customerProfiles()));
            }
            case "qConnect": {
                return Optional.ofNullable(clazz.cast(this.qConnect()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
        }
        return Optional.empty();
    }

    public static IntegrationSummary fromCustomerProfiles(CustomerProfilesIntegrationSummary customerProfiles) {
        return (IntegrationSummary)IntegrationSummary.builder().customerProfiles(customerProfiles).build();
    }

    public static IntegrationSummary fromCustomerProfiles(Consumer<CustomerProfilesIntegrationSummary.Builder> customerProfiles) {
        CustomerProfilesIntegrationSummary.Builder builder = CustomerProfilesIntegrationSummary.builder();
        customerProfiles.accept(builder);
        return IntegrationSummary.fromCustomerProfiles((CustomerProfilesIntegrationSummary)builder.build());
    }

    public static IntegrationSummary fromQConnect(QConnectIntegrationSummary qConnect) {
        return (IntegrationSummary)IntegrationSummary.builder().qConnect(qConnect).build();
    }

    public static IntegrationSummary fromQConnect(Consumer<QConnectIntegrationSummary.Builder> qConnect) {
        QConnectIntegrationSummary.Builder builder = QConnectIntegrationSummary.builder();
        qConnect.accept(builder);
        return IntegrationSummary.fromQConnect((QConnectIntegrationSummary)builder.build());
    }

    public static IntegrationSummary fromLambda(LambdaIntegrationSummary lambda) {
        return (IntegrationSummary)IntegrationSummary.builder().lambda(lambda).build();
    }

    public static IntegrationSummary fromLambda(Consumer<LambdaIntegrationSummary.Builder> lambda) {
        LambdaIntegrationSummary.Builder builder = LambdaIntegrationSummary.builder();
        lambda.accept(builder);
        return IntegrationSummary.fromLambda((LambdaIntegrationSummary)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerProfiles", CUSTOMER_PROFILES_FIELD);
        map.put("qConnect", Q_CONNECT_FIELD);
        map.put("lambda", LAMBDA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntegrationSummary, T> g) {
        return obj -> g.apply((IntegrationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CUSTOMER_PROFILES,
        Q_CONNECT,
        LAMBDA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CustomerProfilesIntegrationSummary customerProfiles;
        private QConnectIntegrationSummary qConnect;
        private LambdaIntegrationSummary lambda;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationSummary model) {
            this.customerProfiles(model.customerProfiles);
            this.qConnect(model.qConnect);
            this.lambda(model.lambda);
        }

        public final CustomerProfilesIntegrationSummary.Builder getCustomerProfiles() {
            return this.customerProfiles != null ? this.customerProfiles.toBuilder() : null;
        }

        public final void setCustomerProfiles(CustomerProfilesIntegrationSummary.BuilderImpl customerProfiles) {
            CustomerProfilesIntegrationSummary oldValue = this.customerProfiles;
            this.customerProfiles = customerProfiles != null ? customerProfiles.build() : null;
            this.handleUnionValueChange(Type.CUSTOMER_PROFILES, oldValue, this.customerProfiles);
        }

        @Override
        public final Builder customerProfiles(CustomerProfilesIntegrationSummary customerProfiles) {
            CustomerProfilesIntegrationSummary oldValue = this.customerProfiles;
            this.customerProfiles = customerProfiles;
            this.handleUnionValueChange(Type.CUSTOMER_PROFILES, oldValue, this.customerProfiles);
            return this;
        }

        public final QConnectIntegrationSummary.Builder getQConnect() {
            return this.qConnect != null ? this.qConnect.toBuilder() : null;
        }

        public final void setQConnect(QConnectIntegrationSummary.BuilderImpl qConnect) {
            QConnectIntegrationSummary oldValue = this.qConnect;
            this.qConnect = qConnect != null ? qConnect.build() : null;
            this.handleUnionValueChange(Type.Q_CONNECT, oldValue, this.qConnect);
        }

        @Override
        public final Builder qConnect(QConnectIntegrationSummary qConnect) {
            QConnectIntegrationSummary oldValue = this.qConnect;
            this.qConnect = qConnect;
            this.handleUnionValueChange(Type.Q_CONNECT, oldValue, this.qConnect);
            return this;
        }

        public final LambdaIntegrationSummary.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaIntegrationSummary.BuilderImpl lambda) {
            LambdaIntegrationSummary oldValue = this.lambda;
            this.lambda = lambda != null ? lambda.build() : null;
            this.handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
        }

        @Override
        public final Builder lambda(LambdaIntegrationSummary lambda) {
            LambdaIntegrationSummary oldValue = this.lambda;
            this.lambda = lambda;
            this.handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
            return this;
        }

        public IntegrationSummary build() {
            return new IntegrationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegrationSummary> {
        public Builder customerProfiles(CustomerProfilesIntegrationSummary var1);

        default public Builder customerProfiles(Consumer<CustomerProfilesIntegrationSummary.Builder> customerProfiles) {
            return this.customerProfiles((CustomerProfilesIntegrationSummary)((CustomerProfilesIntegrationSummary.Builder)CustomerProfilesIntegrationSummary.builder().applyMutation(customerProfiles)).build());
        }

        public Builder qConnect(QConnectIntegrationSummary var1);

        default public Builder qConnect(Consumer<QConnectIntegrationSummary.Builder> qConnect) {
            return this.qConnect((QConnectIntegrationSummary)((QConnectIntegrationSummary.Builder)QConnectIntegrationSummary.builder().applyMutation(qConnect)).build());
        }

        public Builder lambda(LambdaIntegrationSummary var1);

        default public Builder lambda(Consumer<LambdaIntegrationSummary.Builder> lambda) {
            return this.lambda((LambdaIntegrationSummary)((LambdaIntegrationSummary.Builder)LambdaIntegrationSummary.builder().applyMutation(lambda)).build());
        }
    }
}

