/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailureCode {
    INVALID_INPUT("InvalidInput"),
    REQUEST_THROTTLED("RequestThrottled"),
    UNKNOWN_ERROR("UnknownError"),
    BUFFER_LIMIT_EXCEEDED("BufferLimitExceeded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailureCode> VALUE_MAP;
    private final String value;

    private FailureCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailureCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailureCode> knownValues() {
        EnumSet<FailureCode> knownValues = EnumSet.allOf(FailureCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailureCode.class, FailureCode::toString);
    }
}

