/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaignsv2.model.ChannelSubtype;
import software.amazon.awssdk.services.connectcampaignsv2.model.ChannelSubtypeListCopier;
import software.amazon.awssdk.services.connectcampaignsv2.model.Schedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CampaignSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CampaignSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CampaignSummary.getter(CampaignSummary::id)).setter(CampaignSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CampaignSummary.getter(CampaignSummary::arn)).setter(CampaignSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CampaignSummary.getter(CampaignSummary::name)).setter(CampaignSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectInstanceId").getter(CampaignSummary.getter(CampaignSummary::connectInstanceId)).setter(CampaignSummary.setter(Builder::connectInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()}).build();
    private static final SdkField<List<String>> CHANNEL_SUBTYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("channelSubtypes").getter(CampaignSummary.getter(CampaignSummary::channelSubtypesAsStrings)).setter(CampaignSummary.setter(Builder::channelSubtypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(CampaignSummary.getter(CampaignSummary::schedule)).setter(CampaignSummary.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> CONNECT_CAMPAIGN_FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectCampaignFlowArn").getter(CampaignSummary.getter(CampaignSummary::connectCampaignFlowArn)).setter(CampaignSummary.setter(Builder::connectCampaignFlowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCampaignFlowArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, CONNECT_INSTANCE_ID_FIELD, CHANNEL_SUBTYPES_FIELD, SCHEDULE_FIELD, CONNECT_CAMPAIGN_FLOW_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CampaignSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String connectInstanceId;
    private final List<String> channelSubtypes;
    private final Schedule schedule;
    private final String connectCampaignFlowArn;

    private CampaignSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.connectInstanceId = builder.connectInstanceId;
        this.channelSubtypes = builder.channelSubtypes;
        this.schedule = builder.schedule;
        this.connectCampaignFlowArn = builder.connectCampaignFlowArn;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String connectInstanceId() {
        return this.connectInstanceId;
    }

    public final List<ChannelSubtype> channelSubtypes() {
        return ChannelSubtypeListCopier.copyStringToEnum(this.channelSubtypes);
    }

    public final boolean hasChannelSubtypes() {
        return this.channelSubtypes != null && !(this.channelSubtypes instanceof SdkAutoConstructList);
    }

    public final List<String> channelSubtypesAsStrings() {
        return this.channelSubtypes;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final String connectCampaignFlowArn() {
        return this.connectCampaignFlowArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelSubtypes() ? this.channelSubtypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectCampaignFlowArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignSummary)) {
            return false;
        }
        CampaignSummary other = (CampaignSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.connectInstanceId(), other.connectInstanceId()) && this.hasChannelSubtypes() == other.hasChannelSubtypes() && Objects.equals(this.channelSubtypesAsStrings(), other.channelSubtypesAsStrings()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.connectCampaignFlowArn(), other.connectCampaignFlowArn());
    }

    public final String toString() {
        return ToString.builder((String)"CampaignSummary").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("ConnectInstanceId", (Object)this.connectInstanceId()).add("ChannelSubtypes", this.hasChannelSubtypes() ? this.channelSubtypesAsStrings() : null).add("Schedule", (Object)this.schedule()).add("ConnectCampaignFlowArn", (Object)this.connectCampaignFlowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "connectInstanceId": {
                return Optional.ofNullable(clazz.cast(this.connectInstanceId()));
            }
            case "channelSubtypes": {
                return Optional.ofNullable(clazz.cast(this.channelSubtypesAsStrings()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "connectCampaignFlowArn": {
                return Optional.ofNullable(clazz.cast(this.connectCampaignFlowArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
        map.put("channelSubtypes", CHANNEL_SUBTYPES_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("connectCampaignFlowArn", CONNECT_CAMPAIGN_FLOW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CampaignSummary, T> g) {
        return obj -> g.apply((CampaignSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String connectInstanceId;
        private List<String> channelSubtypes = DefaultSdkAutoConstructList.getInstance();
        private Schedule schedule;
        private String connectCampaignFlowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.connectInstanceId(model.connectInstanceId);
            this.channelSubtypesWithStrings(model.channelSubtypes);
            this.schedule(model.schedule);
            this.connectCampaignFlowArn(model.connectCampaignFlowArn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectInstanceId() {
            return this.connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final Collection<String> getChannelSubtypes() {
            if (this.channelSubtypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channelSubtypes;
        }

        public final void setChannelSubtypes(Collection<String> channelSubtypes) {
            this.channelSubtypes = ChannelSubtypeListCopier.copy(channelSubtypes);
        }

        @Override
        public final Builder channelSubtypesWithStrings(Collection<String> channelSubtypes) {
            this.channelSubtypes = ChannelSubtypeListCopier.copy(channelSubtypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelSubtypesWithStrings(String ... channelSubtypes) {
            this.channelSubtypesWithStrings(Arrays.asList(channelSubtypes));
            return this;
        }

        @Override
        public final Builder channelSubtypes(Collection<ChannelSubtype> channelSubtypes) {
            this.channelSubtypes = ChannelSubtypeListCopier.copyEnumToString(channelSubtypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelSubtypes(ChannelSubtype ... channelSubtypes) {
            this.channelSubtypes(Arrays.asList(channelSubtypes));
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getConnectCampaignFlowArn() {
            return this.connectCampaignFlowArn;
        }

        public final void setConnectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
        }

        @Override
        public final Builder connectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
            return this;
        }

        public CampaignSummary build() {
            return new CampaignSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CampaignSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder connectInstanceId(String var1);

        public Builder channelSubtypesWithStrings(Collection<String> var1);

        public Builder channelSubtypesWithStrings(String ... var1);

        public Builder channelSubtypes(Collection<ChannelSubtype> var1);

        public Builder channelSubtypes(ChannelSubtype ... var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder connectCampaignFlowArn(String var1);
    }
}

