/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaignsv2.model.ConnectCampaignsV2Request;
import software.amazon.awssdk.services.connectcampaignsv2.model.ProfileOutboundRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ProfileOutboundRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutProfileOutboundRequestBatchRequest
extends ConnectCampaignsV2Request
implements ToCopyableBuilder<Builder, PutProfileOutboundRequestBatchRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(PutProfileOutboundRequestBatchRequest.getter(PutProfileOutboundRequestBatchRequest::id)).setter(PutProfileOutboundRequestBatchRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<List<ProfileOutboundRequest>> PROFILE_OUTBOUND_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("profileOutboundRequests").getter(PutProfileOutboundRequestBatchRequest.getter(PutProfileOutboundRequestBatchRequest::profileOutboundRequests)).setter(PutProfileOutboundRequestBatchRequest.setter(Builder::profileOutboundRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileOutboundRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileOutboundRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PROFILE_OUTBOUND_REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutProfileOutboundRequestBatchRequest.memberNameToFieldInitializer();
    private final String id;
    private final List<ProfileOutboundRequest> profileOutboundRequests;

    private PutProfileOutboundRequestBatchRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.profileOutboundRequests = builder.profileOutboundRequests;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasProfileOutboundRequests() {
        return this.profileOutboundRequests != null && !(this.profileOutboundRequests instanceof SdkAutoConstructList);
    }

    public final List<ProfileOutboundRequest> profileOutboundRequests() {
        return this.profileOutboundRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileOutboundRequests() ? this.profileOutboundRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProfileOutboundRequestBatchRequest)) {
            return false;
        }
        PutProfileOutboundRequestBatchRequest other = (PutProfileOutboundRequestBatchRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && this.hasProfileOutboundRequests() == other.hasProfileOutboundRequests() && Objects.equals(this.profileOutboundRequests(), other.profileOutboundRequests());
    }

    public final String toString() {
        return ToString.builder((String)"PutProfileOutboundRequestBatchRequest").add("Id", (Object)this.id()).add("ProfileOutboundRequests", this.hasProfileOutboundRequests() ? this.profileOutboundRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "profileOutboundRequests": {
                return Optional.ofNullable(clazz.cast(this.profileOutboundRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("profileOutboundRequests", PROFILE_OUTBOUND_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutProfileOutboundRequestBatchRequest, T> g) {
        return obj -> g.apply((PutProfileOutboundRequestBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCampaignsV2Request.BuilderImpl
    implements Builder {
        private String id;
        private List<ProfileOutboundRequest> profileOutboundRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutProfileOutboundRequestBatchRequest model) {
            super(model);
            this.id(model.id);
            this.profileOutboundRequests(model.profileOutboundRequests);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<ProfileOutboundRequest.Builder> getProfileOutboundRequests() {
            List<ProfileOutboundRequest.Builder> result = ProfileOutboundRequestListCopier.copyToBuilder(this.profileOutboundRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileOutboundRequests(Collection<ProfileOutboundRequest.BuilderImpl> profileOutboundRequests) {
            this.profileOutboundRequests = ProfileOutboundRequestListCopier.copyFromBuilder(profileOutboundRequests);
        }

        @Override
        public final Builder profileOutboundRequests(Collection<ProfileOutboundRequest> profileOutboundRequests) {
            this.profileOutboundRequests = ProfileOutboundRequestListCopier.copy(profileOutboundRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileOutboundRequests(ProfileOutboundRequest ... profileOutboundRequests) {
            this.profileOutboundRequests(Arrays.asList(profileOutboundRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileOutboundRequests(Consumer<ProfileOutboundRequest.Builder> ... profileOutboundRequests) {
            this.profileOutboundRequests(Stream.of(profileOutboundRequests).map(c -> (ProfileOutboundRequest)((ProfileOutboundRequest.Builder)ProfileOutboundRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProfileOutboundRequestBatchRequest build() {
            return new PutProfileOutboundRequestBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCampaignsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutProfileOutboundRequestBatchRequest> {
        public Builder id(String var1);

        public Builder profileOutboundRequests(Collection<ProfileOutboundRequest> var1);

        public Builder profileOutboundRequests(ProfileOutboundRequest ... var1);

        public Builder profileOutboundRequests(Consumer<ProfileOutboundRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

