/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailChannelSubtypeParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailChannelSubtypeParameters> {
    private static final SdkField<String> DESTINATION_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationEmailAddress").getter(EmailChannelSubtypeParameters.getter(EmailChannelSubtypeParameters::destinationEmailAddress)).setter(EmailChannelSubtypeParameters.setter(Builder::destinationEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationEmailAddress").build()}).build();
    private static final SdkField<String> CONNECT_SOURCE_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectSourceEmailAddress").getter(EmailChannelSubtypeParameters.getter(EmailChannelSubtypeParameters::connectSourceEmailAddress)).setter(EmailChannelSubtypeParameters.setter(Builder::connectSourceEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectSourceEmailAddress").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateArn").getter(EmailChannelSubtypeParameters.getter(EmailChannelSubtypeParameters::templateArn)).setter(EmailChannelSubtypeParameters.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateArn").build()}).build();
    private static final SdkField<Map<String, String>> TEMPLATE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("templateParameters").getter(EmailChannelSubtypeParameters.getter(EmailChannelSubtypeParameters::templateParameters)).setter(EmailChannelSubtypeParameters.setter(Builder::templateParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_EMAIL_ADDRESS_FIELD, CONNECT_SOURCE_EMAIL_ADDRESS_FIELD, TEMPLATE_ARN_FIELD, TEMPLATE_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmailChannelSubtypeParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationEmailAddress;
    private final String connectSourceEmailAddress;
    private final String templateArn;
    private final Map<String, String> templateParameters;

    private EmailChannelSubtypeParameters(BuilderImpl builder) {
        this.destinationEmailAddress = builder.destinationEmailAddress;
        this.connectSourceEmailAddress = builder.connectSourceEmailAddress;
        this.templateArn = builder.templateArn;
        this.templateParameters = builder.templateParameters;
    }

    public final String destinationEmailAddress() {
        return this.destinationEmailAddress;
    }

    public final String connectSourceEmailAddress() {
        return this.connectSourceEmailAddress;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final boolean hasTemplateParameters() {
        return this.templateParameters != null && !(this.templateParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> templateParameters() {
        return this.templateParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectSourceEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateParameters() ? this.templateParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelSubtypeParameters)) {
            return false;
        }
        EmailChannelSubtypeParameters other = (EmailChannelSubtypeParameters)obj;
        return Objects.equals(this.destinationEmailAddress(), other.destinationEmailAddress()) && Objects.equals(this.connectSourceEmailAddress(), other.connectSourceEmailAddress()) && Objects.equals(this.templateArn(), other.templateArn()) && this.hasTemplateParameters() == other.hasTemplateParameters() && Objects.equals(this.templateParameters(), other.templateParameters());
    }

    public final String toString() {
        return ToString.builder((String)"EmailChannelSubtypeParameters").add("DestinationEmailAddress", (Object)(this.destinationEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("ConnectSourceEmailAddress", (Object)(this.connectSourceEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplateArn", (Object)this.templateArn()).add("TemplateParameters", (Object)(this.templateParameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.destinationEmailAddress()));
            }
            case "connectSourceEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.connectSourceEmailAddress()));
            }
            case "templateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "templateParameters": {
                return Optional.ofNullable(clazz.cast(this.templateParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationEmailAddress", DESTINATION_EMAIL_ADDRESS_FIELD);
        map.put("connectSourceEmailAddress", CONNECT_SOURCE_EMAIL_ADDRESS_FIELD);
        map.put("templateArn", TEMPLATE_ARN_FIELD);
        map.put("templateParameters", TEMPLATE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailChannelSubtypeParameters, T> g) {
        return obj -> g.apply((EmailChannelSubtypeParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationEmailAddress;
        private String connectSourceEmailAddress;
        private String templateArn;
        private Map<String, String> templateParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelSubtypeParameters model) {
            this.destinationEmailAddress(model.destinationEmailAddress);
            this.connectSourceEmailAddress(model.connectSourceEmailAddress);
            this.templateArn(model.templateArn);
            this.templateParameters(model.templateParameters);
        }

        public final String getDestinationEmailAddress() {
            return this.destinationEmailAddress;
        }

        public final void setDestinationEmailAddress(String destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
        }

        @Override
        public final Builder destinationEmailAddress(String destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
            return this;
        }

        public final String getConnectSourceEmailAddress() {
            return this.connectSourceEmailAddress;
        }

        public final void setConnectSourceEmailAddress(String connectSourceEmailAddress) {
            this.connectSourceEmailAddress = connectSourceEmailAddress;
        }

        @Override
        public final Builder connectSourceEmailAddress(String connectSourceEmailAddress) {
            this.connectSourceEmailAddress = connectSourceEmailAddress;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final Map<String, String> getTemplateParameters() {
            if (this.templateParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.templateParameters;
        }

        public final void setTemplateParameters(Map<String, String> templateParameters) {
            this.templateParameters = AttributesCopier.copy(templateParameters);
        }

        @Override
        public final Builder templateParameters(Map<String, String> templateParameters) {
            this.templateParameters = AttributesCopier.copy(templateParameters);
            return this;
        }

        public EmailChannelSubtypeParameters build() {
            return new EmailChannelSubtypeParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailChannelSubtypeParameters> {
        public Builder destinationEmailAddress(String var1);

        public Builder connectSourceEmailAddress(String var1);

        public Builder templateArn(String var1);

        public Builder templateParameters(Map<String, String> var1);
    }
}

