/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.DailyHoursCopier;
import software.amazon.awssdk.services.connectcampaignsv2.model.DayOfWeek;
import software.amazon.awssdk.services.connectcampaignsv2.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenHours
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenHours> {
    private static final SdkField<Map<String, List<TimeRange>>> DAILY_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("dailyHours").getter(OpenHours.getter(OpenHours::dailyHoursAsStrings)).setter(OpenHours.setter(Builder::dailyHoursWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dailyHours").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAILY_HOURS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dailyHours", DAILY_HOURS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, List<TimeRange>> dailyHours;
    private final Type type;

    private OpenHours(BuilderImpl builder) {
        this.dailyHours = builder.dailyHours;
        this.type = builder.type;
    }

    public final Map<DayOfWeek, List<TimeRange>> dailyHours() {
        return DailyHoursCopier.copyStringToEnum(this.dailyHours);
    }

    public final boolean hasDailyHours() {
        return this.dailyHours != null && !(this.dailyHours instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<TimeRange>> dailyHoursAsStrings() {
        return this.dailyHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDailyHours() ? this.dailyHoursAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenHours)) {
            return false;
        }
        OpenHours other = (OpenHours)obj;
        return this.hasDailyHours() == other.hasDailyHours() && Objects.equals(this.dailyHoursAsStrings(), other.dailyHoursAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"OpenHours").add("DailyHours", this.hasDailyHours() ? this.dailyHoursAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dailyHours": {
                return Optional.ofNullable(clazz.cast(this.dailyHoursAsStrings()));
            }
        }
        return Optional.empty();
    }

    public static OpenHours fromDailyHoursWithStrings(Map<String, List<TimeRange>> dailyHoursWithStrings) {
        return (OpenHours)OpenHours.builder().dailyHoursWithStrings(dailyHoursWithStrings).build();
    }

    public static OpenHours fromDailyHours(Map<DayOfWeek, List<TimeRange>> dailyHoursWithStrings) {
        return (OpenHours)OpenHours.builder().dailyHours(dailyHoursWithStrings).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenHours, T> g) {
        return obj -> g.apply((OpenHours)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DAILY_HOURS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<TimeRange>> dailyHours = DefaultSdkAutoConstructMap.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OpenHours model) {
            this.dailyHoursWithStrings(model.dailyHours);
        }

        public final Map<String, List<TimeRange.Builder>> getDailyHours() {
            Map<String, List<TimeRange.Builder>> result = DailyHoursCopier.copyToBuilder(this.dailyHours);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setDailyHours(Map<String, ? extends Collection<TimeRange.BuilderImpl>> dailyHours) {
            Map<String, List<TimeRange>> oldValue = this.dailyHours;
            this.dailyHours = DailyHoursCopier.copyFromBuilder(dailyHours);
            this.handleUnionValueChange(Type.DAILY_HOURS, oldValue, this.dailyHours);
        }

        @Override
        public final Builder dailyHoursWithStrings(Map<String, ? extends Collection<TimeRange>> dailyHours) {
            Map<String, List<TimeRange>> oldValue = this.dailyHours;
            this.dailyHours = DailyHoursCopier.copy(dailyHours);
            this.handleUnionValueChange(Type.DAILY_HOURS, oldValue, this.dailyHours);
            return this;
        }

        @Override
        public final Builder dailyHours(Map<DayOfWeek, ? extends Collection<TimeRange>> dailyHours) {
            Map<String, List<TimeRange>> oldValue = this.dailyHours;
            this.dailyHours = DailyHoursCopier.copyEnumToString(dailyHours);
            this.handleUnionValueChange(Type.DAILY_HOURS, oldValue, this.dailyHours);
            return this;
        }

        public OpenHours build() {
            return new OpenHours(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenHours> {
        public Builder dailyHoursWithStrings(Map<String, ? extends Collection<TimeRange>> var1);

        public Builder dailyHours(Map<DayOfWeek, ? extends Collection<TimeRange>> var1);
    }
}

