/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.EmailChannelSubtypeParameters;
import software.amazon.awssdk.services.connectcampaignsv2.model.SmsChannelSubtypeParameters;
import software.amazon.awssdk.services.connectcampaignsv2.model.TelephonyChannelSubtypeParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelSubtypeParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelSubtypeParameters> {
    private static final SdkField<TelephonyChannelSubtypeParameters> TELEPHONY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("telephony").getter(ChannelSubtypeParameters.getter(ChannelSubtypeParameters::telephony)).setter(ChannelSubtypeParameters.setter(Builder::telephony)).constructor(TelephonyChannelSubtypeParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telephony").build()}).build();
    private static final SdkField<SmsChannelSubtypeParameters> SMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sms").getter(ChannelSubtypeParameters.getter(ChannelSubtypeParameters::sms)).setter(ChannelSubtypeParameters.setter(Builder::sms)).constructor(SmsChannelSubtypeParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sms").build()}).build();
    private static final SdkField<EmailChannelSubtypeParameters> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("email").getter(ChannelSubtypeParameters.getter(ChannelSubtypeParameters::email)).setter(ChannelSubtypeParameters.setter(Builder::email)).constructor(EmailChannelSubtypeParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEPHONY_FIELD, SMS_FIELD, EMAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("telephony", TELEPHONY_FIELD);
            this.put("sms", SMS_FIELD);
            this.put("email", EMAIL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final TelephonyChannelSubtypeParameters telephony;
    private final SmsChannelSubtypeParameters sms;
    private final EmailChannelSubtypeParameters email;
    private final Type type;

    private ChannelSubtypeParameters(BuilderImpl builder) {
        this.telephony = builder.telephony;
        this.sms = builder.sms;
        this.email = builder.email;
        this.type = builder.type;
    }

    public final TelephonyChannelSubtypeParameters telephony() {
        return this.telephony;
    }

    public final SmsChannelSubtypeParameters sms() {
        return this.sms;
    }

    public final EmailChannelSubtypeParameters email() {
        return this.email;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.telephony());
        hashCode = 31 * hashCode + Objects.hashCode(this.sms());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSubtypeParameters)) {
            return false;
        }
        ChannelSubtypeParameters other = (ChannelSubtypeParameters)obj;
        return Objects.equals(this.telephony(), other.telephony()) && Objects.equals(this.sms(), other.sms()) && Objects.equals(this.email(), other.email());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelSubtypeParameters").add("Telephony", (Object)this.telephony()).add("Sms", (Object)this.sms()).add("Email", (Object)this.email()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "telephony": {
                return Optional.ofNullable(clazz.cast(this.telephony()));
            }
            case "sms": {
                return Optional.ofNullable(clazz.cast(this.sms()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
        }
        return Optional.empty();
    }

    public static ChannelSubtypeParameters fromTelephony(TelephonyChannelSubtypeParameters telephony) {
        return (ChannelSubtypeParameters)ChannelSubtypeParameters.builder().telephony(telephony).build();
    }

    public static ChannelSubtypeParameters fromTelephony(Consumer<TelephonyChannelSubtypeParameters.Builder> telephony) {
        TelephonyChannelSubtypeParameters.Builder builder = TelephonyChannelSubtypeParameters.builder();
        telephony.accept(builder);
        return ChannelSubtypeParameters.fromTelephony((TelephonyChannelSubtypeParameters)builder.build());
    }

    public static ChannelSubtypeParameters fromSms(SmsChannelSubtypeParameters sms) {
        return (ChannelSubtypeParameters)ChannelSubtypeParameters.builder().sms(sms).build();
    }

    public static ChannelSubtypeParameters fromSms(Consumer<SmsChannelSubtypeParameters.Builder> sms) {
        SmsChannelSubtypeParameters.Builder builder = SmsChannelSubtypeParameters.builder();
        sms.accept(builder);
        return ChannelSubtypeParameters.fromSms((SmsChannelSubtypeParameters)builder.build());
    }

    public static ChannelSubtypeParameters fromEmail(EmailChannelSubtypeParameters email) {
        return (ChannelSubtypeParameters)ChannelSubtypeParameters.builder().email(email).build();
    }

    public static ChannelSubtypeParameters fromEmail(Consumer<EmailChannelSubtypeParameters.Builder> email) {
        EmailChannelSubtypeParameters.Builder builder = EmailChannelSubtypeParameters.builder();
        email.accept(builder);
        return ChannelSubtypeParameters.fromEmail((EmailChannelSubtypeParameters)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChannelSubtypeParameters, T> g) {
        return obj -> g.apply((ChannelSubtypeParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TELEPHONY,
        SMS,
        EMAIL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TelephonyChannelSubtypeParameters telephony;
        private SmsChannelSubtypeParameters sms;
        private EmailChannelSubtypeParameters email;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSubtypeParameters model) {
            this.telephony(model.telephony);
            this.sms(model.sms);
            this.email(model.email);
        }

        public final TelephonyChannelSubtypeParameters.Builder getTelephony() {
            return this.telephony != null ? this.telephony.toBuilder() : null;
        }

        public final void setTelephony(TelephonyChannelSubtypeParameters.BuilderImpl telephony) {
            TelephonyChannelSubtypeParameters oldValue = this.telephony;
            this.telephony = telephony != null ? telephony.build() : null;
            this.handleUnionValueChange(Type.TELEPHONY, oldValue, this.telephony);
        }

        @Override
        public final Builder telephony(TelephonyChannelSubtypeParameters telephony) {
            TelephonyChannelSubtypeParameters oldValue = this.telephony;
            this.telephony = telephony;
            this.handleUnionValueChange(Type.TELEPHONY, oldValue, this.telephony);
            return this;
        }

        public final SmsChannelSubtypeParameters.Builder getSms() {
            return this.sms != null ? this.sms.toBuilder() : null;
        }

        public final void setSms(SmsChannelSubtypeParameters.BuilderImpl sms) {
            SmsChannelSubtypeParameters oldValue = this.sms;
            this.sms = sms != null ? sms.build() : null;
            this.handleUnionValueChange(Type.SMS, oldValue, this.sms);
        }

        @Override
        public final Builder sms(SmsChannelSubtypeParameters sms) {
            SmsChannelSubtypeParameters oldValue = this.sms;
            this.sms = sms;
            this.handleUnionValueChange(Type.SMS, oldValue, this.sms);
            return this;
        }

        public final EmailChannelSubtypeParameters.Builder getEmail() {
            return this.email != null ? this.email.toBuilder() : null;
        }

        public final void setEmail(EmailChannelSubtypeParameters.BuilderImpl email) {
            EmailChannelSubtypeParameters oldValue = this.email;
            this.email = email != null ? email.build() : null;
            this.handleUnionValueChange(Type.EMAIL, oldValue, this.email);
        }

        @Override
        public final Builder email(EmailChannelSubtypeParameters email) {
            EmailChannelSubtypeParameters oldValue = this.email;
            this.email = email;
            this.handleUnionValueChange(Type.EMAIL, oldValue, this.email);
            return this;
        }

        public ChannelSubtypeParameters build() {
            return new ChannelSubtypeParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelSubtypeParameters> {
        public Builder telephony(TelephonyChannelSubtypeParameters var1);

        default public Builder telephony(Consumer<TelephonyChannelSubtypeParameters.Builder> telephony) {
            return this.telephony((TelephonyChannelSubtypeParameters)((TelephonyChannelSubtypeParameters.Builder)TelephonyChannelSubtypeParameters.builder().applyMutation(telephony)).build());
        }

        public Builder sms(SmsChannelSubtypeParameters var1);

        default public Builder sms(Consumer<SmsChannelSubtypeParameters.Builder> sms) {
            return this.sms((SmsChannelSubtypeParameters)((SmsChannelSubtypeParameters.Builder)SmsChannelSubtypeParameters.builder().applyMutation(sms)).build());
        }

        public Builder email(EmailChannelSubtypeParameters var1);

        default public Builder email(Consumer<EmailChannelSubtypeParameters.Builder> email) {
            return this.email((EmailChannelSubtypeParameters)((EmailChannelSubtypeParameters.Builder)EmailChannelSubtypeParameters.builder().applyMutation(email)).build());
        }
    }
}

