/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.EventType;
import software.amazon.awssdk.services.connectcampaignsv2.model.ObjectTypeNamesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerProfilesIntegrationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerProfilesIntegrationSummary> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainArn").getter(CustomerProfilesIntegrationSummary.getter(CustomerProfilesIntegrationSummary::domainArn)).setter(CustomerProfilesIntegrationSummary.setter(Builder::domainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainArn").build()}).build();
    private static final SdkField<Map<String, String>> OBJECT_TYPE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("objectTypeNames").getter(CustomerProfilesIntegrationSummary.getter(CustomerProfilesIntegrationSummary::objectTypeNamesAsStrings)).setter(CustomerProfilesIntegrationSummary.setter(Builder::objectTypeNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectTypeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD, OBJECT_TYPE_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("domainArn", DOMAIN_ARN_FIELD);
            this.put("objectTypeNames", OBJECT_TYPE_NAMES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String domainArn;
    private final Map<String, String> objectTypeNames;

    private CustomerProfilesIntegrationSummary(BuilderImpl builder) {
        this.domainArn = builder.domainArn;
        this.objectTypeNames = builder.objectTypeNames;
    }

    public final String domainArn() {
        return this.domainArn;
    }

    public final Map<EventType, String> objectTypeNames() {
        return ObjectTypeNamesMapCopier.copyStringToEnum(this.objectTypeNames);
    }

    public final boolean hasObjectTypeNames() {
        return this.objectTypeNames != null && !(this.objectTypeNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> objectTypeNamesAsStrings() {
        return this.objectTypeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectTypeNames() ? this.objectTypeNamesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerProfilesIntegrationSummary)) {
            return false;
        }
        CustomerProfilesIntegrationSummary other = (CustomerProfilesIntegrationSummary)obj;
        return Objects.equals(this.domainArn(), other.domainArn()) && this.hasObjectTypeNames() == other.hasObjectTypeNames() && Objects.equals(this.objectTypeNamesAsStrings(), other.objectTypeNamesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerProfilesIntegrationSummary").add("DomainArn", (Object)this.domainArn()).add("ObjectTypeNames", this.hasObjectTypeNames() ? this.objectTypeNamesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainArn": {
                return Optional.ofNullable(clazz.cast(this.domainArn()));
            }
            case "objectTypeNames": {
                return Optional.ofNullable(clazz.cast(this.objectTypeNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomerProfilesIntegrationSummary, T> g) {
        return obj -> g.apply((CustomerProfilesIntegrationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainArn;
        private Map<String, String> objectTypeNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerProfilesIntegrationSummary model) {
            this.domainArn(model.domainArn);
            this.objectTypeNamesWithStrings(model.objectTypeNames);
        }

        public final String getDomainArn() {
            return this.domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final Map<String, String> getObjectTypeNames() {
            if (this.objectTypeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.objectTypeNames;
        }

        public final void setObjectTypeNames(Map<String, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesMapCopier.copy(objectTypeNames);
        }

        @Override
        public final Builder objectTypeNamesWithStrings(Map<String, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesMapCopier.copy(objectTypeNames);
            return this;
        }

        @Override
        public final Builder objectTypeNames(Map<EventType, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesMapCopier.copyEnumToString(objectTypeNames);
            return this;
        }

        public CustomerProfilesIntegrationSummary build() {
            return new CustomerProfilesIntegrationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerProfilesIntegrationSummary> {
        public Builder domainArn(String var1);

        public Builder objectTypeNamesWithStrings(Map<String, String> var1);

        public Builder objectTypeNames(Map<EventType, String> var1);
    }
}

