/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcampaignsv2.model.ChannelSubtypeConfig;
import software.amazon.awssdk.services.connectcampaignsv2.model.CommunicationLimitsConfig;
import software.amazon.awssdk.services.connectcampaignsv2.model.CommunicationTimeConfig;
import software.amazon.awssdk.services.connectcampaignsv2.model.ConnectCampaignsV2Request;
import software.amazon.awssdk.services.connectcampaignsv2.model.Schedule;
import software.amazon.awssdk.services.connectcampaignsv2.model.Source;
import software.amazon.awssdk.services.connectcampaignsv2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCampaignRequest
extends ConnectCampaignsV2Request
implements ToCopyableBuilder<Builder, CreateCampaignRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCampaignRequest.getter(CreateCampaignRequest::name)).setter(CreateCampaignRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CONNECT_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectInstanceId").getter(CreateCampaignRequest.getter(CreateCampaignRequest::connectInstanceId)).setter(CreateCampaignRequest.setter(Builder::connectInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceId").build()}).build();
    private static final SdkField<ChannelSubtypeConfig> CHANNEL_SUBTYPE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channelSubtypeConfig").getter(CreateCampaignRequest.getter(CreateCampaignRequest::channelSubtypeConfig)).setter(CreateCampaignRequest.setter(Builder::channelSubtypeConfig)).constructor(ChannelSubtypeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelSubtypeConfig").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(CreateCampaignRequest.getter(CreateCampaignRequest::source)).setter(CreateCampaignRequest.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> CONNECT_CAMPAIGN_FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectCampaignFlowArn").getter(CreateCampaignRequest.getter(CreateCampaignRequest::connectCampaignFlowArn)).setter(CreateCampaignRequest.setter(Builder::connectCampaignFlowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCampaignFlowArn").build()}).build();
    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(CreateCampaignRequest.getter(CreateCampaignRequest::schedule)).setter(CreateCampaignRequest.setter(Builder::schedule)).constructor(Schedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<CommunicationTimeConfig> COMMUNICATION_TIME_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("communicationTimeConfig").getter(CreateCampaignRequest.getter(CreateCampaignRequest::communicationTimeConfig)).setter(CreateCampaignRequest.setter(Builder::communicationTimeConfig)).constructor(CommunicationTimeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationTimeConfig").build()}).build();
    private static final SdkField<CommunicationLimitsConfig> COMMUNICATION_LIMITS_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("communicationLimitsOverride").getter(CreateCampaignRequest.getter(CreateCampaignRequest::communicationLimitsOverride)).setter(CreateCampaignRequest.setter(Builder::communicationLimitsOverride)).constructor(CommunicationLimitsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("communicationLimitsOverride").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateCampaignRequest.getter(CreateCampaignRequest::tags)).setter(CreateCampaignRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONNECT_INSTANCE_ID_FIELD, CHANNEL_SUBTYPE_CONFIG_FIELD, SOURCE_FIELD, CONNECT_CAMPAIGN_FLOW_ARN_FIELD, SCHEDULE_FIELD, COMMUNICATION_TIME_CONFIG_FIELD, COMMUNICATION_LIMITS_OVERRIDE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("connectInstanceId", CONNECT_INSTANCE_ID_FIELD);
            this.put("channelSubtypeConfig", CHANNEL_SUBTYPE_CONFIG_FIELD);
            this.put("source", SOURCE_FIELD);
            this.put("connectCampaignFlowArn", CONNECT_CAMPAIGN_FLOW_ARN_FIELD);
            this.put("schedule", SCHEDULE_FIELD);
            this.put("communicationTimeConfig", COMMUNICATION_TIME_CONFIG_FIELD);
            this.put("communicationLimitsOverride", COMMUNICATION_LIMITS_OVERRIDE_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final String connectInstanceId;
    private final ChannelSubtypeConfig channelSubtypeConfig;
    private final Source source;
    private final String connectCampaignFlowArn;
    private final Schedule schedule;
    private final CommunicationTimeConfig communicationTimeConfig;
    private final CommunicationLimitsConfig communicationLimitsOverride;
    private final Map<String, String> tags;

    private CreateCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.connectInstanceId = builder.connectInstanceId;
        this.channelSubtypeConfig = builder.channelSubtypeConfig;
        this.source = builder.source;
        this.connectCampaignFlowArn = builder.connectCampaignFlowArn;
        this.schedule = builder.schedule;
        this.communicationTimeConfig = builder.communicationTimeConfig;
        this.communicationLimitsOverride = builder.communicationLimitsOverride;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String connectInstanceId() {
        return this.connectInstanceId;
    }

    public final ChannelSubtypeConfig channelSubtypeConfig() {
        return this.channelSubtypeConfig;
    }

    public final Source source() {
        return this.source;
    }

    public final String connectCampaignFlowArn() {
        return this.connectCampaignFlowArn;
    }

    public final Schedule schedule() {
        return this.schedule;
    }

    public final CommunicationTimeConfig communicationTimeConfig() {
        return this.communicationTimeConfig;
    }

    public final CommunicationLimitsConfig communicationLimitsOverride() {
        return this.communicationLimitsOverride;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelSubtypeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectCampaignFlowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.communicationTimeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.communicationLimitsOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCampaignRequest)) {
            return false;
        }
        CreateCampaignRequest other = (CreateCampaignRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.connectInstanceId(), other.connectInstanceId()) && Objects.equals(this.channelSubtypeConfig(), other.channelSubtypeConfig()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.connectCampaignFlowArn(), other.connectCampaignFlowArn()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.communicationTimeConfig(), other.communicationTimeConfig()) && Objects.equals(this.communicationLimitsOverride(), other.communicationLimitsOverride()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCampaignRequest").add("Name", (Object)this.name()).add("ConnectInstanceId", (Object)this.connectInstanceId()).add("ChannelSubtypeConfig", (Object)this.channelSubtypeConfig()).add("Source", (Object)this.source()).add("ConnectCampaignFlowArn", (Object)this.connectCampaignFlowArn()).add("Schedule", (Object)this.schedule()).add("CommunicationTimeConfig", (Object)this.communicationTimeConfig()).add("CommunicationLimitsOverride", (Object)this.communicationLimitsOverride()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "connectInstanceId": {
                return Optional.ofNullable(clazz.cast(this.connectInstanceId()));
            }
            case "channelSubtypeConfig": {
                return Optional.ofNullable(clazz.cast(this.channelSubtypeConfig()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "connectCampaignFlowArn": {
                return Optional.ofNullable(clazz.cast(this.connectCampaignFlowArn()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "communicationTimeConfig": {
                return Optional.ofNullable(clazz.cast(this.communicationTimeConfig()));
            }
            case "communicationLimitsOverride": {
                return Optional.ofNullable(clazz.cast(this.communicationLimitsOverride()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCampaignRequest, T> g) {
        return obj -> g.apply((CreateCampaignRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCampaignsV2Request.BuilderImpl
    implements Builder {
        private String name;
        private String connectInstanceId;
        private ChannelSubtypeConfig channelSubtypeConfig;
        private Source source;
        private String connectCampaignFlowArn;
        private Schedule schedule;
        private CommunicationTimeConfig communicationTimeConfig;
        private CommunicationLimitsConfig communicationLimitsOverride;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCampaignRequest model) {
            super(model);
            this.name(model.name);
            this.connectInstanceId(model.connectInstanceId);
            this.channelSubtypeConfig(model.channelSubtypeConfig);
            this.source(model.source);
            this.connectCampaignFlowArn(model.connectCampaignFlowArn);
            this.schedule(model.schedule);
            this.communicationTimeConfig(model.communicationTimeConfig);
            this.communicationLimitsOverride(model.communicationLimitsOverride);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectInstanceId() {
            return this.connectInstanceId;
        }

        public final void setConnectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
        }

        @Override
        public final Builder connectInstanceId(String connectInstanceId) {
            this.connectInstanceId = connectInstanceId;
            return this;
        }

        public final ChannelSubtypeConfig.Builder getChannelSubtypeConfig() {
            return this.channelSubtypeConfig != null ? this.channelSubtypeConfig.toBuilder() : null;
        }

        public final void setChannelSubtypeConfig(ChannelSubtypeConfig.BuilderImpl channelSubtypeConfig) {
            this.channelSubtypeConfig = channelSubtypeConfig != null ? channelSubtypeConfig.build() : null;
        }

        @Override
        public final Builder channelSubtypeConfig(ChannelSubtypeConfig channelSubtypeConfig) {
            this.channelSubtypeConfig = channelSubtypeConfig;
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final String getConnectCampaignFlowArn() {
            return this.connectCampaignFlowArn;
        }

        public final void setConnectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
        }

        @Override
        public final Builder connectCampaignFlowArn(String connectCampaignFlowArn) {
            this.connectCampaignFlowArn = connectCampaignFlowArn;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final CommunicationTimeConfig.Builder getCommunicationTimeConfig() {
            return this.communicationTimeConfig != null ? this.communicationTimeConfig.toBuilder() : null;
        }

        public final void setCommunicationTimeConfig(CommunicationTimeConfig.BuilderImpl communicationTimeConfig) {
            this.communicationTimeConfig = communicationTimeConfig != null ? communicationTimeConfig.build() : null;
        }

        @Override
        public final Builder communicationTimeConfig(CommunicationTimeConfig communicationTimeConfig) {
            this.communicationTimeConfig = communicationTimeConfig;
            return this;
        }

        public final CommunicationLimitsConfig.Builder getCommunicationLimitsOverride() {
            return this.communicationLimitsOverride != null ? this.communicationLimitsOverride.toBuilder() : null;
        }

        public final void setCommunicationLimitsOverride(CommunicationLimitsConfig.BuilderImpl communicationLimitsOverride) {
            this.communicationLimitsOverride = communicationLimitsOverride != null ? communicationLimitsOverride.build() : null;
        }

        @Override
        public final Builder communicationLimitsOverride(CommunicationLimitsConfig communicationLimitsOverride) {
            this.communicationLimitsOverride = communicationLimitsOverride;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCampaignRequest build() {
            return new CreateCampaignRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCampaignsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCampaignRequest> {
        public Builder name(String var1);

        public Builder connectInstanceId(String var1);

        public Builder channelSubtypeConfig(ChannelSubtypeConfig var1);

        default public Builder channelSubtypeConfig(Consumer<ChannelSubtypeConfig.Builder> channelSubtypeConfig) {
            return this.channelSubtypeConfig((ChannelSubtypeConfig)((ChannelSubtypeConfig.Builder)ChannelSubtypeConfig.builder().applyMutation(channelSubtypeConfig)).build());
        }

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder connectCampaignFlowArn(String var1);

        public Builder schedule(Schedule var1);

        default public Builder schedule(Consumer<Schedule.Builder> schedule) {
            return this.schedule((Schedule)((Schedule.Builder)Schedule.builder().applyMutation(schedule)).build());
        }

        public Builder communicationTimeConfig(CommunicationTimeConfig var1);

        default public Builder communicationTimeConfig(Consumer<CommunicationTimeConfig.Builder> communicationTimeConfig) {
            return this.communicationTimeConfig((CommunicationTimeConfig)((CommunicationTimeConfig.Builder)CommunicationTimeConfig.builder().applyMutation(communicationTimeConfig)).build());
        }

        public Builder communicationLimitsOverride(CommunicationLimitsConfig var1);

        default public Builder communicationLimitsOverride(Consumer<CommunicationLimitsConfig.Builder> communicationLimitsOverride) {
            return this.communicationLimitsOverride((CommunicationLimitsConfig)((CommunicationLimitsConfig.Builder)CommunicationLimitsConfig.builder().applyMutation(communicationLimitsOverride)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

