/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * GetConnectInstanceConfigResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectInstanceConfigResponse extends ConnectCampaignsResponse implements
        ToCopyableBuilder<GetConnectInstanceConfigResponse.Builder, GetConnectInstanceConfigResponse> {
    private static final SdkField<InstanceConfig> CONNECT_INSTANCE_CONFIG_FIELD = SdkField
            .<InstanceConfig> builder(MarshallingType.SDK_POJO).memberName("connectInstanceConfig")
            .getter(getter(GetConnectInstanceConfigResponse::connectInstanceConfig))
            .setter(setter(Builder::connectInstanceConfig)).constructor(InstanceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectInstanceConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONNECT_INSTANCE_CONFIG_FIELD));

    private final InstanceConfig connectInstanceConfig;

    private GetConnectInstanceConfigResponse(BuilderImpl builder) {
        super(builder);
        this.connectInstanceConfig = builder.connectInstanceConfig;
    }

    /**
     * Returns the value of the ConnectInstanceConfig property for this object.
     * 
     * @return The value of the ConnectInstanceConfig property for this object.
     */
    public final InstanceConfig connectInstanceConfig() {
        return connectInstanceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectInstanceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectInstanceConfigResponse)) {
            return false;
        }
        GetConnectInstanceConfigResponse other = (GetConnectInstanceConfigResponse) obj;
        return Objects.equals(connectInstanceConfig(), other.connectInstanceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectInstanceConfigResponse").add("ConnectInstanceConfig", connectInstanceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectInstanceConfig":
            return Optional.ofNullable(clazz.cast(connectInstanceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectInstanceConfigResponse, T> g) {
        return obj -> g.apply((GetConnectInstanceConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCampaignsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConnectInstanceConfigResponse> {
        /**
         * Sets the value of the ConnectInstanceConfig property for this object.
         *
         * @param connectInstanceConfig
         *        The new value for the ConnectInstanceConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectInstanceConfig(InstanceConfig connectInstanceConfig);

        /**
         * Sets the value of the ConnectInstanceConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InstanceConfig.Builder} avoiding the need
         * to create one manually via {@link InstanceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #connectInstanceConfig(InstanceConfig)}.
         * 
         * @param connectInstanceConfig
         *        a consumer that will call methods on {@link InstanceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectInstanceConfig(InstanceConfig)
         */
        default Builder connectInstanceConfig(Consumer<InstanceConfig.Builder> connectInstanceConfig) {
            return connectInstanceConfig(InstanceConfig.builder().applyMutation(connectInstanceConfig).build());
        }
    }

    static final class BuilderImpl extends ConnectCampaignsResponse.BuilderImpl implements Builder {
        private InstanceConfig connectInstanceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectInstanceConfigResponse model) {
            super(model);
            connectInstanceConfig(model.connectInstanceConfig);
        }

        public final InstanceConfig.Builder getConnectInstanceConfig() {
            return connectInstanceConfig != null ? connectInstanceConfig.toBuilder() : null;
        }

        public final void setConnectInstanceConfig(InstanceConfig.BuilderImpl connectInstanceConfig) {
            this.connectInstanceConfig = connectInstanceConfig != null ? connectInstanceConfig.build() : null;
        }

        @Override
        public final Builder connectInstanceConfig(InstanceConfig connectInstanceConfig) {
            this.connectInstanceConfig = connectInstanceConfig;
            return this;
        }

        @Override
        public GetConnectInstanceConfigResponse build() {
            return new GetConnectInstanceConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
