/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.connectcampaigns.ConnectCampaignsClient;
import software.amazon.awssdk.services.connectcampaigns.model.AccessDeniedException;
import software.amazon.awssdk.services.connectcampaigns.model.ConflictException;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsException;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsRequest;
import software.amazon.awssdk.services.connectcampaigns.model.CreateCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.CreateCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DeleteInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaigns.model.DescribeCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.DescribeCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateBatchRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateBatchResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetConnectInstanceConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetConnectInstanceConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.GetInstanceOnboardingJobStatusRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetInstanceOnboardingJobStatusResponse;
import software.amazon.awssdk.services.connectcampaigns.model.InternalServerException;
import software.amazon.awssdk.services.connectcampaigns.model.InvalidCampaignStateException;
import software.amazon.awssdk.services.connectcampaigns.model.InvalidStateException;
import software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ListCampaignsResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.PauseCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.PauseCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.PutDialRequestBatchRequest;
import software.amazon.awssdk.services.connectcampaigns.model.PutDialRequestBatchResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connectcampaigns.model.ResumeCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.ResumeCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.connectcampaigns.model.StartCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StartCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.StartInstanceOnboardingJobRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StartInstanceOnboardingJobResponse;
import software.amazon.awssdk.services.connectcampaigns.model.StopCampaignRequest;
import software.amazon.awssdk.services.connectcampaigns.model.StopCampaignResponse;
import software.amazon.awssdk.services.connectcampaigns.model.TagResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.TagResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ThrottlingException;
import software.amazon.awssdk.services.connectcampaigns.model.UntagResourceRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UntagResourceResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignDialerConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignDialerConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignNameRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignNameResponse;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignOutboundCallConfigRequest;
import software.amazon.awssdk.services.connectcampaigns.model.UpdateCampaignOutboundCallConfigResponse;
import software.amazon.awssdk.services.connectcampaigns.model.ValidationException;
import software.amazon.awssdk.services.connectcampaigns.paginators.ListCampaignsIterable;
import software.amazon.awssdk.services.connectcampaigns.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.DeleteConnectInstanceConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.DeleteInstanceOnboardingJobRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.DescribeCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.GetCampaignStateBatchRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.GetCampaignStateRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.GetConnectInstanceConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.GetInstanceOnboardingJobStatusRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.ListCampaignsRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.PauseCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.PutDialRequestBatchRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.ResumeCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.StartCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.StartInstanceOnboardingJobRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.StopCampaignRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.UpdateCampaignDialerConfigRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.UpdateCampaignNameRequestMarshaller;
import software.amazon.awssdk.services.connectcampaigns.transform.UpdateCampaignOutboundCallConfigRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultConnectCampaignsClient
implements ConnectCampaignsClient {
    private static final Logger log = Logger.loggerFor(DefaultConnectCampaignsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConnectCampaignsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, createCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCampaign");
            CreateCampaignResponse createCampaignResponse = (CreateCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$createCampaign$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, deleteCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCampaign");
            DeleteCampaignResponse deleteCampaignResponse = (DeleteCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$deleteCampaign$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectInstanceConfigResponse deleteConnectInstanceConfig(DeleteConnectInstanceConfigRequest deleteConnectInstanceConfigRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidStateException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConnectInstanceConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, deleteConnectInstanceConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConnectInstanceConfig");
            DeleteConnectInstanceConfigResponse deleteConnectInstanceConfigResponse = (DeleteConnectInstanceConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConnectInstanceConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteConnectInstanceConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConnectInstanceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConnectInstanceConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$deleteConnectInstanceConfig$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInstanceOnboardingJobResponse deleteInstanceOnboardingJob(DeleteInstanceOnboardingJobRequest deleteInstanceOnboardingJobRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, InvalidStateException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceOnboardingJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, deleteInstanceOnboardingJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInstanceOnboardingJob");
            DeleteInstanceOnboardingJobResponse deleteInstanceOnboardingJobResponse = (DeleteInstanceOnboardingJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstanceOnboardingJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInstanceOnboardingJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInstanceOnboardingJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInstanceOnboardingJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$deleteInstanceOnboardingJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCampaignResponse describeCampaign(DescribeCampaignRequest describeCampaignRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, describeCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCampaign");
            DescribeCampaignResponse describeCampaignResponse = (DescribeCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$describeCampaign$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCampaignStateResponse getCampaignState(GetCampaignStateRequest getCampaignStateRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCampaignStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, getCampaignStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCampaignState");
            GetCampaignStateResponse getCampaignStateResponse = (GetCampaignStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCampaignState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCampaignStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCampaignStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCampaignStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$getCampaignState$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCampaignStateBatchResponse getCampaignStateBatch(GetCampaignStateBatchRequest getCampaignStateBatchRequest) throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCampaignStateBatchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, getCampaignStateBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCampaignStateBatch");
            GetCampaignStateBatchResponse getCampaignStateBatchResponse = (GetCampaignStateBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCampaignStateBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCampaignStateBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCampaignStateBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCampaignStateBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$getCampaignStateBatch$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConnectInstanceConfigResponse getConnectInstanceConfig(GetConnectInstanceConfigRequest getConnectInstanceConfigRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConnectInstanceConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, getConnectInstanceConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConnectInstanceConfig");
            GetConnectInstanceConfigResponse getConnectInstanceConfigResponse = (GetConnectInstanceConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConnectInstanceConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConnectInstanceConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConnectInstanceConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConnectInstanceConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$getConnectInstanceConfig$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInstanceOnboardingJobStatusResponse getInstanceOnboardingJobStatus(GetInstanceOnboardingJobStatusRequest getInstanceOnboardingJobStatusRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInstanceOnboardingJobStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, getInstanceOnboardingJobStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInstanceOnboardingJobStatus");
            GetInstanceOnboardingJobStatusResponse getInstanceOnboardingJobStatusResponse = (GetInstanceOnboardingJobStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInstanceOnboardingJobStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInstanceOnboardingJobStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInstanceOnboardingJobStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInstanceOnboardingJobStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$getInstanceOnboardingJobStatus$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCampaignsResponse listCampaigns(ListCampaignsRequest listCampaignsRequest) throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCampaignsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, listCampaignsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCampaigns");
            ListCampaignsResponse listCampaignsResponse = (ListCampaignsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCampaigns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCampaignsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCampaignsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCampaignsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$listCampaigns$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCampaignsIterable listCampaignsPaginator(ListCampaignsRequest listCampaignsRequest) throws InternalServerException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        return new ListCampaignsIterable(this, this.applyPaginatorUserAgent(listCampaignsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$listTagsForResource$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PauseCampaignResponse pauseCampaign(PauseCampaignRequest pauseCampaignRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PauseCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, pauseCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PauseCampaign");
            PauseCampaignResponse pauseCampaignResponse = (PauseCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PauseCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)pauseCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PauseCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return pauseCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$pauseCampaign$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutDialRequestBatchResponse putDialRequestBatch(PutDialRequestBatchRequest putDialRequestBatchRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDialRequestBatchResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, putDialRequestBatchRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDialRequestBatch");
            PutDialRequestBatchResponse putDialRequestBatchResponse = (PutDialRequestBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDialRequestBatch").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDialRequestBatchRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutDialRequestBatchRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putDialRequestBatchResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$putDialRequestBatch$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResumeCampaignResponse resumeCampaign(ResumeCampaignRequest resumeCampaignRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResumeCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, resumeCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResumeCampaign");
            ResumeCampaignResponse resumeCampaignResponse = (ResumeCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResumeCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resumeCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResumeCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resumeCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$resumeCampaign$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCampaignResponse startCampaign(StartCampaignRequest startCampaignRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, startCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCampaign");
            StartCampaignResponse startCampaignResponse = (StartCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$startCampaign$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartInstanceOnboardingJobResponse startInstanceOnboardingJob(StartInstanceOnboardingJobRequest startInstanceOnboardingJobRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartInstanceOnboardingJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, startInstanceOnboardingJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInstanceOnboardingJob");
            StartInstanceOnboardingJobResponse startInstanceOnboardingJobResponse = (StartInstanceOnboardingJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInstanceOnboardingJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startInstanceOnboardingJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartInstanceOnboardingJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startInstanceOnboardingJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$startInstanceOnboardingJob$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopCampaignResponse stopCampaign(StopCampaignRequest stopCampaignRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, InvalidCampaignStateException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopCampaignResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, stopCampaignRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopCampaign");
            StopCampaignResponse stopCampaignResponse = (StopCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopCampaign").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopCampaignRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopCampaignRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopCampaignResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$stopCampaign$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$tagResource$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$untagResource$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCampaignDialerConfigResponse updateCampaignDialerConfig(UpdateCampaignDialerConfigRequest updateCampaignDialerConfigRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCampaignDialerConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, updateCampaignDialerConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCampaignDialerConfig");
            UpdateCampaignDialerConfigResponse updateCampaignDialerConfigResponse = (UpdateCampaignDialerConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCampaignDialerConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCampaignDialerConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCampaignDialerConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCampaignDialerConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$updateCampaignDialerConfig$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCampaignNameResponse updateCampaignName(UpdateCampaignNameRequest updateCampaignNameRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCampaignNameResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, updateCampaignNameRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCampaignName");
            UpdateCampaignNameResponse updateCampaignNameResponse = (UpdateCampaignNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCampaignName").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCampaignNameRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCampaignNameRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCampaignNameResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$updateCampaignName$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCampaignOutboundCallConfigResponse updateCampaignOutboundCallConfig(UpdateCampaignOutboundCallConfigRequest updateCampaignOutboundCallConfigRequest) throws InternalServerException, ResourceNotFoundException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, ConnectCampaignsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCampaignOutboundCallConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultConnectCampaignsClient.resolveMetricPublishers(this.clientConfiguration, updateCampaignOutboundCallConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ConnectCampaigns");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCampaignOutboundCallConfig");
            UpdateCampaignOutboundCallConfigResponse updateCampaignOutboundCallConfigResponse = (UpdateCampaignOutboundCallConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCampaignOutboundCallConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCampaignOutboundCallConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCampaignOutboundCallConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCampaignOutboundCallConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultConnectCampaignsClient.lambda$updateCampaignOutboundCallConfig$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends ConnectCampaignsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.27").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ConnectCampaignsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "connect-campaigns";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ConnectCampaignsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCampaignStateException").exceptionBuilderSupplier(InvalidCampaignStateException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateException").exceptionBuilderSupplier(InvalidStateException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateCampaignOutboundCallConfig$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCampaignName$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCampaignDialerConfig$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopCampaign$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startInstanceOnboardingJob$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCampaign$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resumeCampaign$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDialRequestBatch$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pauseCampaign$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCampaigns$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInstanceOnboardingJobStatus$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConnectInstanceConfig$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCampaignStateBatch$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCampaignState$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCampaign$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInstanceOnboardingJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConnectInstanceConfig$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCampaign$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCampaign$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

